/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.Camera;
import com.android.tools.layoutlib.create.OverrideMethod;

public class CamcorderProfile {
    public static final int QUALITY_LOW = 0;
    public static final int QUALITY_HIGH = 1;
    public static final int QUALITY_QCIF = 2;
    public static final int QUALITY_CIF = 3;
    public static final int QUALITY_480P = 4;
    public static final int QUALITY_720P = 5;
    public static final int QUALITY_1080P = 6;
    public static final int QUALITY_QVGA = 7;
    public static final int QUALITY_2160P = 8;
    private static final int QUALITY_LIST_START = 0;
    private static final int QUALITY_LIST_END = 8;
    public static final int QUALITY_TIME_LAPSE_LOW = 1000;
    public static final int QUALITY_TIME_LAPSE_HIGH = 1001;
    public static final int QUALITY_TIME_LAPSE_QCIF = 1002;
    public static final int QUALITY_TIME_LAPSE_CIF = 1003;
    public static final int QUALITY_TIME_LAPSE_480P = 1004;
    public static final int QUALITY_TIME_LAPSE_720P = 1005;
    public static final int QUALITY_TIME_LAPSE_1080P = 1006;
    public static final int QUALITY_TIME_LAPSE_QVGA = 1007;
    public static final int QUALITY_TIME_LAPSE_2160P = 1008;
    private static final int QUALITY_TIME_LAPSE_LIST_START = 1000;
    private static final int QUALITY_TIME_LAPSE_LIST_END = 1008;
    public static final int QUALITY_HIGH_SPEED_LOW = 2000;
    public static final int QUALITY_HIGH_SPEED_HIGH = 2001;
    public static final int QUALITY_HIGH_SPEED_480P = 2002;
    public static final int QUALITY_HIGH_SPEED_720P = 2003;
    public static final int QUALITY_HIGH_SPEED_1080P = 2004;
    public static final int QUALITY_HIGH_SPEED_2160P = 2005;
    private static final int QUALITY_HIGH_SPEED_LIST_START = 2000;
    private static final int QUALITY_HIGH_SPEED_LIST_END = 2005;
    public int duration;
    public int quality;
    public int fileFormat;
    public int videoCodec;
    public int videoBitRate;
    public int videoFrameRate;
    public int videoFrameWidth;
    public int videoFrameHeight;
    public int audioCodec;
    public int audioBitRate;
    public int audioSampleRate;
    public int audioChannels;

    public static CamcorderProfile get(int quality) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CamcorderProfile.get(i, quality);
        }
        return null;
    }

    public static CamcorderProfile get(int cameraId, int quality) {
        if (!(quality >= 0 && quality <= 8 || quality >= 1000 && quality <= 1008 || quality >= 2000 && quality <= 2005)) {
            String errMessage = "Unsupported quality level: " + quality;
            throw new IllegalArgumentException(errMessage);
        }
        return CamcorderProfile.native_get_camcorder_profile(cameraId, quality);
    }

    public static boolean hasProfile(int quality) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CamcorderProfile.hasProfile(i, quality);
        }
        return false;
    }

    public static boolean hasProfile(int cameraId, int quality) {
        return CamcorderProfile.native_has_camcorder_profile(cameraId, quality);
    }

    private CamcorderProfile(int duration, int quality, int fileFormat, int videoCodec, int videoBitRate, int videoFrameRate, int videoWidth, int videoHeight, int audioCodec, int audioBitRate, int audioSampleRate, int audioChannels) {
        this.duration = duration;
        this.quality = quality;
        this.fileFormat = fileFormat;
        this.videoCodec = videoCodec;
        this.videoBitRate = videoBitRate;
        this.videoFrameRate = videoFrameRate;
        this.videoFrameWidth = videoWidth;
        this.videoFrameHeight = videoHeight;
        this.audioCodec = audioCodec;
        this.audioBitRate = audioBitRate;
        this.audioSampleRate = audioSampleRate;
        this.audioChannels = audioChannels;
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.CamcorderProfile#native_init()V", true, null);
    }

    private static CamcorderProfile native_get_camcorder_profile(int n, int n2) {
        return (CamcorderProfile)OverrideMethod.invokeA("android.media.CamcorderProfile#native_get_camcorder_profile(II)Landroid/media/CamcorderProfile;", true, null);
    }

    private static boolean native_has_camcorder_profile(int n, int n2) {
        return OverrideMethod.invokeI("android.media.CamcorderProfile#native_has_camcorder_profile(II)Z", true, null) != 0;
    }

    static {
        System.loadLibrary("media_jni");
        CamcorderProfile.native_init();
    }
}

