/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.os.Parcel;
import android.os.Parcelable;

public class HdmiDeviceInfo
implements Parcelable {
    public static final int DEVICE_TV = 0;
    public static final int DEVICE_RECORDER = 1;
    public static final int DEVICE_RESERVED = 2;
    public static final int DEVICE_TUNER = 3;
    public static final int DEVICE_PLAYBACK = 4;
    public static final int DEVICE_AUDIO_SYSTEM = 5;
    public static final int DEVICE_PURE_CEC_SWITCH = 6;
    public static final int DEVICE_VIDEO_PROCESSOR = 7;
    public static final int DEVICE_INACTIVE = -1;
    public static final int ADDR_INTERNAL = 0;
    public static final int PATH_INTERNAL = 0;
    public static final int PATH_INVALID = 65535;
    public static final int PORT_INVALID = -1;
    public static final int ID_INVALID = 65535;
    public static final HdmiDeviceInfo INACTIVE_DEVICE = new HdmiDeviceInfo();
    private static final int HDMI_DEVICE_TYPE_CEC = 0;
    private static final int HDMI_DEVICE_TYPE_MHL = 1;
    private static final int HDMI_DEVICE_TYPE_HARDWARE = 2;
    private static final int HDMI_DEVICE_TYPE_INACTIVE = 100;
    private static final int ID_OFFSET_CEC = 0;
    private static final int ID_OFFSET_MHL = 128;
    private static final int ID_OFFSET_HARDWARE = 192;
    private final int mId;
    private final int mHdmiDeviceType;
    private final int mPhysicalAddress;
    private final int mPortId;
    private final int mLogicalAddress;
    private final int mDeviceType;
    private final int mVendorId;
    private final String mDisplayName;
    private final int mDevicePowerStatus;
    private final int mDeviceId;
    private final int mAdopterId;
    public static final Parcelable.Creator<HdmiDeviceInfo> CREATOR = new Parcelable.Creator<HdmiDeviceInfo>(){

        @Override
        public HdmiDeviceInfo createFromParcel(Parcel source) {
            int hdmiDeviceType = source.readInt();
            int physicalAddress = source.readInt();
            int portId = source.readInt();
            switch (hdmiDeviceType) {
                case 0: {
                    int logicalAddress = source.readInt();
                    int deviceType = source.readInt();
                    int vendorId = source.readInt();
                    int powerStatus = source.readInt();
                    String displayName = source.readString();
                    return new HdmiDeviceInfo(logicalAddress, physicalAddress, portId, deviceType, vendorId, displayName, powerStatus);
                }
                case 1: {
                    int deviceId = source.readInt();
                    int adopterId = source.readInt();
                    return new HdmiDeviceInfo(physicalAddress, portId, adopterId, deviceId);
                }
                case 2: {
                    return new HdmiDeviceInfo(physicalAddress, portId);
                }
                case 100: {
                    return INACTIVE_DEVICE;
                }
            }
            return null;
        }

        public HdmiDeviceInfo[] newArray(int size) {
            return new HdmiDeviceInfo[size];
        }
    };

    public HdmiDeviceInfo(int logicalAddress, int physicalAddress, int portId, int deviceType, int vendorId, String displayName, int powerStatus) {
        this.mHdmiDeviceType = 0;
        this.mPhysicalAddress = physicalAddress;
        this.mPortId = portId;
        this.mId = HdmiDeviceInfo.idForCecDevice(logicalAddress);
        this.mLogicalAddress = logicalAddress;
        this.mDeviceType = deviceType;
        this.mVendorId = vendorId;
        this.mDevicePowerStatus = powerStatus;
        this.mDisplayName = displayName;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    public HdmiDeviceInfo(int logicalAddress, int physicalAddress, int portId, int deviceType, int vendorId, String displayName) {
        this(logicalAddress, physicalAddress, portId, deviceType, vendorId, displayName, -1);
    }

    public HdmiDeviceInfo(int physicalAddress, int portId) {
        this.mHdmiDeviceType = 2;
        this.mPhysicalAddress = physicalAddress;
        this.mPortId = portId;
        this.mId = HdmiDeviceInfo.idForHardware(portId);
        this.mLogicalAddress = -1;
        this.mDeviceType = 2;
        this.mVendorId = 0;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "HDMI" + portId;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    public HdmiDeviceInfo(int physicalAddress, int portId, int adopterId, int deviceId) {
        this.mHdmiDeviceType = 1;
        this.mPhysicalAddress = physicalAddress;
        this.mPortId = portId;
        this.mId = HdmiDeviceInfo.idForMhlDevice(portId);
        this.mLogicalAddress = -1;
        this.mDeviceType = 2;
        this.mVendorId = 0;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "Mobile";
        this.mDeviceId = adopterId;
        this.mAdopterId = deviceId;
    }

    public HdmiDeviceInfo() {
        this.mHdmiDeviceType = 100;
        this.mPhysicalAddress = 65535;
        this.mId = 65535;
        this.mLogicalAddress = -1;
        this.mDeviceType = -1;
        this.mPortId = -1;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "Inactive";
        this.mVendorId = 0;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    public int getId() {
        return this.mId;
    }

    public static int idForCecDevice(int address) {
        return 0 + address;
    }

    public static int idForMhlDevice(int portId) {
        return 128 + portId;
    }

    public static int idForHardware(int portId) {
        return 192 + portId;
    }

    public int getLogicalAddress() {
        return this.mLogicalAddress;
    }

    public int getPhysicalAddress() {
        return this.mPhysicalAddress;
    }

    public int getPortId() {
        return this.mPortId;
    }

    public int getDeviceType() {
        return this.mDeviceType;
    }

    public int getDevicePowerStatus() {
        return this.mDevicePowerStatus;
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public int getAdopterId() {
        return this.mAdopterId;
    }

    public boolean isSourceType() {
        if (this.isCecDevice()) {
            return this.mDeviceType == 4 || this.mDeviceType == 1 || this.mDeviceType == 3;
        }
        return this.isMhlDevice();
    }

    public boolean isCecDevice() {
        return this.mHdmiDeviceType == 0;
    }

    public boolean isMhlDevice() {
        return this.mHdmiDeviceType == 1;
    }

    public boolean isInactivated() {
        return this.mHdmiDeviceType == 100;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mHdmiDeviceType);
        dest.writeInt(this.mPhysicalAddress);
        dest.writeInt(this.mPortId);
        switch (this.mHdmiDeviceType) {
            case 0: {
                dest.writeInt(this.mLogicalAddress);
                dest.writeInt(this.mDeviceType);
                dest.writeInt(this.mVendorId);
                dest.writeInt(this.mDevicePowerStatus);
                dest.writeString(this.mDisplayName);
                break;
            }
            case 1: {
                dest.writeInt(this.mDeviceId);
                dest.writeInt(this.mAdopterId);
                break;
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        switch (this.mHdmiDeviceType) {
            case 0: {
                s.append("CEC: ");
                s.append("logical_address: ").append(String.format("0x%02X", this.mLogicalAddress));
                s.append(" ");
                s.append("device_type: ").append(this.mDeviceType).append(" ");
                s.append("vendor_id: ").append(this.mVendorId).append(" ");
                s.append("display_name: ").append(this.mDisplayName).append(" ");
                s.append("power_status: ").append(this.mDevicePowerStatus).append(" ");
                break;
            }
            case 1: {
                s.append("MHL: ");
                s.append("device_id: ").append(String.format("0x%04X", this.mDeviceId)).append(" ");
                s.append("adopter_id: ").append(String.format("0x%04X", this.mAdopterId)).append(" ");
                break;
            }
            case 2: {
                s.append("Hardware: ");
                break;
            }
            case 100: {
                s.append("Inactivated: ");
                break;
            }
            default: {
                return "";
            }
        }
        s.append("physical_address: ").append(String.format("0x%04X", this.mPhysicalAddress));
        s.append(" ");
        s.append("port_id: ").append(this.mPortId);
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HdmiDeviceInfo)) {
            return false;
        }
        HdmiDeviceInfo other = (HdmiDeviceInfo)obj;
        return this.mHdmiDeviceType == other.mHdmiDeviceType && this.mPhysicalAddress == other.mPhysicalAddress && this.mPortId == other.mPortId && this.mLogicalAddress == other.mLogicalAddress && this.mDeviceType == other.mDeviceType && this.mVendorId == other.mVendorId && this.mDevicePowerStatus == other.mDevicePowerStatus && this.mDisplayName.equals(other.mDisplayName) && this.mDeviceId == other.mDeviceId && this.mAdopterId == other.mAdopterId;
    }
}

