/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.util.Size;
import com.android.internal.util.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SizeAreaComparator
implements Comparator<Size> {
    @Override
    public int compare(Size size, Size size2) {
        long area2;
        Preconditions.checkNotNull(size, "size must not be null");
        Preconditions.checkNotNull(size2, "size2 must not be null");
        if (size.equals(size2)) {
            return 0;
        }
        long width = size.getWidth();
        long width2 = size2.getWidth();
        long area = width * (long)size.getHeight();
        if (area == (area2 = width2 * (long)size2.getHeight())) {
            return width > width2 ? 1 : -1;
        }
        return area > area2 ? 1 : -1;
    }

    public static Size findLargestByArea(List<Size> sizes) {
        Preconditions.checkNotNull(sizes, "sizes must not be null");
        return Collections.max(sizes, new SizeAreaComparator());
    }
}

