/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraConstrainedHighSpeedCaptureSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.ICameraDeviceUserWrapper;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.SubmitInfo;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraDeviceImpl
extends CameraDevice
implements IBinder.DeathRecipient {
    private final String TAG;
    private final boolean DEBUG = false;
    private static final int REQUEST_ID_NONE = -1;
    private ICameraDeviceUserWrapper mRemoteDevice;
    final Object mInterfaceLock = new Object();
    private final CameraDeviceCallbacks mCallbacks = new CameraDeviceCallbacks();
    private final CameraDevice.StateCallback mDeviceCallback;
    private volatile StateCallbackKK mSessionStateCallback;
    private final Handler mDeviceHandler;
    private final AtomicBoolean mClosing = new AtomicBoolean();
    private boolean mInError = false;
    private boolean mIdle = true;
    private final SparseArray<CaptureCallbackHolder> mCaptureCallbackMap = new SparseArray();
    private int mRepeatingRequestId = -1;
    private AbstractMap.SimpleEntry<Integer, InputConfiguration> mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
    private final SparseArray<OutputConfiguration> mConfiguredOutputs = new SparseArray();
    private final String mCameraId;
    private final CameraCharacteristics mCharacteristics;
    private final int mTotalPartialCount;
    private final List<RequestLastFrameNumbersHolder> mRequestLastFrameNumbersList = new ArrayList<RequestLastFrameNumbersHolder>();
    private final FrameNumberTracker mFrameNumberTracker = new FrameNumberTracker();
    private CameraCaptureSessionCore mCurrentSession;
    private int mNextSessionId = 0;
    private final Runnable mCallOnOpened = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onOpened(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onOpened(CameraDeviceImpl.this);
        }
    };
    private final Runnable mCallOnUnconfigured = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onUnconfigured(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnActive = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onActive(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnBusy = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onBusy(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnClosed = new Runnable(){
        private boolean mClosedOnce = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mClosedOnce) {
                throw new AssertionError((Object)"Don't post #onClosed more than once");
            }
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onClosed(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onClosed(CameraDeviceImpl.this);
            this.mClosedOnce = true;
        }
    };
    private final Runnable mCallOnIdle = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onIdle(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnDisconnected = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onDisconnected(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
        }
    };

    public CameraDeviceImpl(String cameraId, CameraDevice.StateCallback callback, Handler handler, CameraCharacteristics characteristics) {
        if (cameraId == null || callback == null || handler == null || characteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mDeviceCallback = callback;
        this.mDeviceHandler = handler;
        this.mCharacteristics = characteristics;
        int MAX_TAG_LEN = 23;
        String tag = String.format("CameraDevice-JV-%s", this.mCameraId);
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        this.TAG = tag;
        Integer partialCount = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        this.mTotalPartialCount = partialCount == null ? 1 : partialCount;
    }

    public CameraDeviceCallbacks getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteDevice(ICameraDeviceUser remoteDevice) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInError) {
                return;
            }
            this.mRemoteDevice = new ICameraDeviceUserWrapper(remoteDevice);
            IBinder remoteDeviceBinder = remoteDevice.asBinder();
            if (remoteDeviceBinder != null) {
                try {
                    remoteDeviceBinder.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.mDeviceHandler.post(this.mCallOnDisconnected);
                    throw new CameraAccessException(2, "The camera device has encountered a serious error");
                }
            }
            this.mDeviceHandler.post(this.mCallOnOpened);
            this.mDeviceHandler.post(this.mCallOnUnconfigured);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteFailure(ServiceSpecificException failure) {
        int failureCode = 4;
        boolean failureIsError = true;
        switch (failure.errorCode) {
            case 7: {
                failureCode = 1;
                break;
            }
            case 8: {
                failureCode = 2;
                break;
            }
            case 6: {
                failureCode = 3;
                break;
            }
            case 4: {
                failureIsError = false;
                break;
            }
            case 10: {
                failureCode = 4;
                break;
            }
            default: {
                Log.e(this.TAG, "Unexpected failure in opening camera device: " + failure.errorCode + failure.getMessage());
            }
        }
        final int code = failureCode;
        final boolean isError = failureIsError;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInError = true;
            this.mDeviceHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (isError) {
                        CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, code);
                    } else {
                        CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
                    }
                }
            });
        }
    }

    @Override
    public String getId() {
        return this.mCameraId;
    }

    public void configureOutputs(List<Surface> outputs) throws CameraAccessException {
        ArrayList<OutputConfiguration> outputConfigs = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface s : outputs) {
            outputConfigs.add(new OutputConfiguration(s));
        }
        this.configureStreamsChecked(null, outputConfigs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configureStreamsChecked(InputConfiguration inputConfig, List<OutputConfiguration> outputs, boolean isConstrainedHighSpeed) throws CameraAccessException {
        if (outputs == null) {
            outputs = new ArrayList<OutputConfiguration>();
        }
        if (outputs.size() == 0 && inputConfig != null) {
            throw new IllegalArgumentException("cannot configure an input stream without any output streams");
        }
        this.checkInputConfiguration(inputConfig);
        boolean success = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId;
            this.checkIfCameraClosedOrInError();
            HashSet<OutputConfiguration> addSet = new HashSet<OutputConfiguration>(outputs);
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                streamId = this.mConfiguredOutputs.keyAt(i);
                OutputConfiguration outConfig = this.mConfiguredOutputs.valueAt(i);
                if (!outputs.contains(outConfig)) {
                    deleteList.add(streamId);
                    continue;
                }
                addSet.remove(outConfig);
            }
            this.mDeviceHandler.post(this.mCallOnBusy);
            this.stopRepeating();
            try {
                this.waitUntilIdle();
                this.mRemoteDevice.beginConfigure();
                InputConfiguration currentInputConfig = this.mConfiguredInput.getValue();
                if (!(inputConfig == currentInputConfig || inputConfig != null && inputConfig.equals(currentInputConfig))) {
                    if (currentInputConfig != null) {
                        this.mRemoteDevice.deleteStream(this.mConfiguredInput.getKey());
                        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
                    }
                    if (inputConfig != null) {
                        streamId = this.mRemoteDevice.createInputStream(inputConfig.getWidth(), inputConfig.getHeight(), inputConfig.getFormat());
                        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, InputConfiguration>(streamId, inputConfig);
                    }
                }
                for (Integer streamId2 : deleteList) {
                    this.mRemoteDevice.deleteStream(streamId2);
                    this.mConfiguredOutputs.delete(streamId2);
                }
                for (OutputConfiguration outConfig : outputs) {
                    if (!addSet.contains(outConfig)) continue;
                    int streamId3 = this.mRemoteDevice.createStream(outConfig);
                    this.mConfiguredOutputs.put(streamId3, outConfig);
                }
                this.mRemoteDevice.endConfigure(isConstrainedHighSpeed);
                success = true;
            }
            catch (IllegalArgumentException e) {
                Log.w(this.TAG, "Stream configuration failed due to: " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            catch (CameraAccessException e) {
                if (e.getReason() != 4) throw e;
                throw new IllegalStateException("The camera is currently busy. You must wait until the previous operation completes.", e);
            }
            finally {
                if (success && outputs.size() > 0) {
                    this.mDeviceHandler.post(this.mCallOnIdle);
                } else {
                    this.mDeviceHandler.post(this.mCallOnUnconfigured);
                }
            }
            return success;
        }
    }

    @Override
    public void createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(null, outConfigurations, callback, handler, false);
    }

    @Override
    public void createCaptureSessionByOutputConfigurations(List<OutputConfiguration> outputConfigurations, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>(outputConfigurations);
        this.createCaptureSessionInternal(null, currentOutputs, callback, handler, false);
    }

    @Override
    public void createReprocessableCaptureSession(InputConfiguration inputConfig, List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (inputConfig == null) {
            throw new IllegalArgumentException("inputConfig cannot be null when creating a reprocessable capture session");
        }
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(inputConfig, outConfigurations, callback, handler, false);
    }

    @Override
    public void createReprocessableCaptureSessionByConfigurations(InputConfiguration inputConfig, List<OutputConfiguration> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (inputConfig == null) {
            throw new IllegalArgumentException("inputConfig cannot be null when creating a reprocessable capture session");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Output configurations cannot be null when creating a reprocessable capture session");
        }
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>();
        for (OutputConfiguration output : outputs) {
            currentOutputs.add(new OutputConfiguration(output));
        }
        this.createCaptureSessionInternal(inputConfig, currentOutputs, callback, handler, false);
    }

    @Override
    public void createConstrainedHighSpeedCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (outputs == null || outputs.size() == 0 || outputs.size() > 2) {
            throw new IllegalArgumentException("Output surface list must not be null and the size must be no more than 2");
        }
        StreamConfigurationMap config = this.getCharacteristics().get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        SurfaceUtils.checkConstrainedHighSpeedSurfaces(outputs, null, config);
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(null, outConfigurations, callback, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCaptureSessionInternal(InputConfiguration inputConfig, List<OutputConfiguration> outputConfigurations, CameraCaptureSession.StateCallback callback, Handler handler, boolean isConstrainedHighSpeed) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (isConstrainedHighSpeed && inputConfig != null) {
                throw new IllegalArgumentException("Constrained high speed session doesn't support input configuration yet.");
            }
            if (this.mCurrentSession != null) {
                this.mCurrentSession.replaceSessionClose();
            }
            boolean configureSuccess = true;
            CameraAccessException pendingException = null;
            Surface input = null;
            try {
                configureSuccess = this.configureStreamsChecked(inputConfig, outputConfigurations, isConstrainedHighSpeed);
                if (configureSuccess && inputConfig != null) {
                    input = this.mRemoteDevice.getInputSurface();
                }
            }
            catch (CameraAccessException e) {
                configureSuccess = false;
                pendingException = e;
                input = null;
            }
            ArrayList<Surface> outSurfaces = new ArrayList<Surface>(outputConfigurations.size());
            for (OutputConfiguration config : outputConfigurations) {
                outSurfaces.add(config.getSurface());
            }
            CameraCaptureSession newSession = null;
            newSession = isConstrainedHighSpeed ? new CameraConstrainedHighSpeedCaptureSessionImpl(this.mNextSessionId++, outSurfaces, callback, handler, this, this.mDeviceHandler, configureSuccess, this.mCharacteristics) : new CameraCaptureSessionImpl(this.mNextSessionId++, input, outSurfaces, callback, handler, this, this.mDeviceHandler, configureSuccess);
            this.mCurrentSession = newSession;
            if (pendingException != null) {
                throw pendingException;
            }
            this.mSessionStateCallback = this.mCurrentSession.getDeviceStateCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionListener(StateCallbackKK sessionCallback) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mSessionStateCallback = sessionCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative templatedRequest = null;
            templatedRequest = this.mRemoteDevice.createDefaultRequest(templateType);
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest, false, -1);
            return builder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createReprocessCaptureRequest(TotalCaptureResult inputResult) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative resultMetadata = new CameraMetadataNative(inputResult.getNativeCopy());
            return new CaptureRequest.Builder(resultMetadata, true, inputResult.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.prepare(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(int maxCount, Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        if (maxCount <= 0) {
            throw new IllegalArgumentException("Invalid maxCount given: " + maxCount);
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.prepare2(maxCount, streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown(Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.tearDown(streamId);
        }
    }

    public int capture(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, false);
    }

    public int captureBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, false);
    }

    private void checkEarlyTriggerSequenceComplete(final int requestId, long lastFrameNumber) {
        if (lastFrameNumber == -1L) {
            CaptureCallbackHolder holder;
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
            if (holder != null) {
                this.mCaptureCallbackMap.removeAt(index);
            }
            if (holder != null) {
                Runnable resultDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureSequenceAborted(CameraDeviceImpl.this, requestId);
                        }
                    }
                };
                holder.getHandler().post(resultDispatch);
            } else {
                Log.w(this.TAG, String.format("did not register callback to request %d", requestId));
            }
        } else {
            this.mRequestLastFrameNumbersList.add(new RequestLastFrameNumbersHolder(requestId, lastFrameNumber));
            this.checkAndFireSequenceComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitCaptureRequest(List<CaptureRequest> requestList, CaptureCallback callback, Handler handler, boolean repeating) throws CameraAccessException {
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                throw new IllegalArgumentException("Each request must have at least one Surface target");
            }
            for (Surface surface : request.getTargets()) {
                if (surface != null) continue;
                throw new IllegalArgumentException("Null Surface targets are not allowed");
            }
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (repeating) {
                this.stopRepeating();
            }
            CaptureRequest[] requestArray = requestList.toArray(new CaptureRequest[requestList.size()]);
            SubmitInfo requestInfo = this.mRemoteDevice.submitRequestList(requestArray, repeating);
            if (callback != null) {
                this.mCaptureCallbackMap.put(requestInfo.getRequestId(), new CaptureCallbackHolder(callback, requestList, handler, repeating, this.mNextSessionId - 1));
            }
            if (repeating) {
                if (this.mRepeatingRequestId != -1) {
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, requestInfo.getLastFrameNumber());
                }
                this.mRepeatingRequestId = requestInfo.getRequestId();
            } else {
                this.mRequestLastFrameNumbersList.add(new RequestLastFrameNumbersHolder(requestList, requestInfo));
            }
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnActive);
            }
            this.mIdle = false;
            return requestInfo.getRequestId();
        }
    }

    public int setRepeatingRequest(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, true);
    }

    public int setRepeatingBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                long lastFrameNumber;
                int requestId = this.mRepeatingRequestId;
                this.mRepeatingRequestId = -1;
                try {
                    lastFrameNumber = this.mRemoteDevice.cancelRequest(requestId);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                this.checkEarlyTriggerSequenceComplete(requestId, lastFrameNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilIdle() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            this.mRemoteDevice.waitUntilIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mDeviceHandler.post(this.mCallOnBusy);
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnIdle);
                return;
            }
            long lastFrameNumber = this.mRemoteDevice.flush();
            if (this.mRepeatingRequestId != -1) {
                this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, lastFrameNumber);
                this.mRepeatingRequestId = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mClosing.getAndSet(true)) {
                return;
            }
            if (this.mRemoteDevice != null) {
                this.mRemoteDevice.disconnect();
                this.mRemoteDevice.unlinkToDeath(this, 0);
            }
            if (this.mRemoteDevice != null || this.mInError) {
                this.mDeviceHandler.post(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkInputConfiguration(InputConfiguration inputConfig) {
        if (inputConfig != null) {
            Size[] inputSizes;
            StreamConfigurationMap configMap = this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            int[] inputFormats = configMap.getInputFormats();
            boolean validFormat = false;
            for (int format : inputFormats) {
                if (format != inputConfig.getFormat()) continue;
                validFormat = true;
            }
            if (!validFormat) {
                throw new IllegalArgumentException("input format " + inputConfig.getFormat() + " is not valid");
            }
            boolean validSize = false;
            for (Size s : inputSizes = configMap.getInputSizes(inputConfig.getFormat())) {
                if (inputConfig.getWidth() != s.getWidth() || inputConfig.getHeight() != s.getHeight()) continue;
                validSize = true;
            }
            if (!validSize) {
                throw new IllegalArgumentException("input size " + inputConfig.getWidth() + "x" + inputConfig.getHeight() + " is not valid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndFireSequenceComplete() {
        long completedFrameNumber = this.mFrameNumberTracker.getCompletedFrameNumber();
        long completedReprocessFrameNumber = this.mFrameNumberTracker.getCompletedReprocessFrameNumber();
        boolean isReprocess = false;
        Iterator<RequestLastFrameNumbersHolder> iter = this.mRequestLastFrameNumbersList.iterator();
        while (iter.hasNext()) {
            CaptureCallbackHolder holder;
            final RequestLastFrameNumbersHolder requestLastFrameNumbers = iter.next();
            boolean sequenceCompleted = false;
            final int requestId = requestLastFrameNumbers.getRequestId();
            Object object = this.mInterfaceLock;
            synchronized (object) {
                if (this.mRemoteDevice == null) {
                    Log.w(this.TAG, "Camera closed while checking sequences");
                    return;
                }
                int index = this.mCaptureCallbackMap.indexOfKey(requestId);
                CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
                if (holder != null) {
                    long lastRegularFrameNumber = requestLastFrameNumbers.getLastRegularFrameNumber();
                    long lastReprocessFrameNumber = requestLastFrameNumbers.getLastReprocessFrameNumber();
                    if (lastRegularFrameNumber <= completedFrameNumber && lastReprocessFrameNumber <= completedReprocessFrameNumber) {
                        sequenceCompleted = true;
                        this.mCaptureCallbackMap.removeAt(index);
                    }
                }
            }
            if (holder == null || sequenceCompleted) {
                iter.remove();
            }
            if (!sequenceCompleted) continue;
            Runnable resultDispatch = new Runnable(){

                @Override
                public void run() {
                    if (!CameraDeviceImpl.this.isClosed()) {
                        holder.getCallback().onCaptureSequenceCompleted(CameraDeviceImpl.this, requestId, requestLastFrameNumbers.getLastFrameNumber());
                    }
                }
            };
            holder.getHandler().post(resultDispatch);
        }
    }

    static Handler checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    static <T> Handler checkHandler(Handler handler, T callback) {
        if (callback != null) {
            return CameraDeviceImpl.checkHandler(handler);
        }
        return handler;
    }

    private void checkIfCameraClosedOrInError() throws CameraAccessException {
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
        if (this.mInError) {
            throw new CameraAccessException(3, "The camera device has encountered a serious error");
        }
    }

    private boolean isClosed() {
        return this.mClosing.get();
    }

    private CameraCharacteristics getCharacteristics() {
        return this.mCharacteristics;
    }

    @Override
    public void binderDied() {
        Log.w(this.TAG, "CameraDevice " + this.mCameraId + " died unexpectedly");
        if (this.mRemoteDevice == null) {
            return;
        }
        this.mInError = true;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!CameraDeviceImpl.this.isClosed()) {
                    CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, 5);
                }
            }
        };
        this.mDeviceHandler.post(r);
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub {
        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                switch (errorCode) {
                    case 0: {
                        CameraDeviceImpl.this.mDeviceHandler.post(CameraDeviceImpl.this.mCallOnDisconnected);
                        break;
                    }
                    default: {
                        Log.e(CameraDeviceImpl.this.TAG, "Unknown error from camera device: " + errorCode);
                    }
                    case 1: 
                    case 2: {
                        CameraDeviceImpl.this.mInError = true;
                        final int publicErrorCode = errorCode == 1 ? 4 : 5;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                if (!CameraDeviceImpl.this.isClosed()) {
                                    CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, publicErrorCode);
                                }
                            }
                        };
                        CameraDeviceImpl.this.mDeviceHandler.post(r);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.onCaptureErrorLocked(errorCode, resultExtras);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRepeatingRequestError(long lastFrameNumber) {
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null || CameraDeviceImpl.this.mRepeatingRequestId == -1) {
                    return;
                }
                CameraDeviceImpl.this.checkEarlyTriggerSequenceComplete(CameraDeviceImpl.this.mRepeatingRequestId, lastFrameNumber);
                CameraDeviceImpl.this.mRepeatingRequestId = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceIdle() {
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                if (!CameraDeviceImpl.this.mIdle) {
                    CameraDeviceImpl.this.mDeviceHandler.post(CameraDeviceImpl.this.mCallOnIdle);
                }
                CameraDeviceImpl.this.mIdle = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(final CaptureResultExtras resultExtras, final long timestamp) {
            int requestId = resultExtras.getRequestId();
            final long frameNumber = resultExtras.getFrameNumber();
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
                if (holder == null) {
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    return;
                }
                holder.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureStarted(CameraDeviceImpl.this, holder.getRequest(resultExtras.getSubsequenceId()), timestamp, frameNumber);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) throws RemoteException {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                CaptureResult finalResult;
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                result.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, CameraDeviceImpl.this.getCharacteristics().get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
                final CaptureRequest request = holder.getRequest(resultExtras.getSubsequenceId());
                boolean isPartialResult = resultExtras.getPartialResultCount() < CameraDeviceImpl.this.mTotalPartialCount;
                boolean isReprocess = request.isReprocess();
                if (holder == null) {
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, isReprocess);
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, isReprocess);
                    return;
                }
                Runnable resultDispatch = null;
                if (isPartialResult) {
                    final CaptureResult resultAsCapture = new CaptureResult(result, request, resultExtras);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                holder.getCallback().onCaptureProgressed(CameraDeviceImpl.this, request, resultAsCapture);
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                } else {
                    List<CaptureResult> partialResults = CameraDeviceImpl.this.mFrameNumberTracker.popPartialResults(frameNumber);
                    final TotalCaptureResult resultAsCapture = new TotalCaptureResult(result, request, resultExtras, partialResults, holder.getSessionId());
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                holder.getCallback().onCaptureCompleted(CameraDeviceImpl.this, request, resultAsCapture);
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                }
                holder.getHandler().post(resultDispatch);
                CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, finalResult, isPartialResult, isReprocess);
                if (!isPartialResult) {
                    CameraDeviceImpl.this.checkAndFireSequenceComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrepared(int streamId) {
            StateCallbackKK sessionCallback;
            OutputConfiguration output;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                output = (OutputConfiguration)CameraDeviceImpl.this.mConfiguredOutputs.get(streamId);
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback == null) {
                return;
            }
            if (output == null) {
                Log.w(CameraDeviceImpl.this.TAG, "onPrepared invoked for unknown output Surface");
                return;
            }
            Surface surface = output.getSurface();
            sessionCallback.onSurfacePrepared(surface);
        }

        private void onCaptureErrorLocked(int errorCode, CaptureResultExtras resultExtras) {
            int requestId = resultExtras.getRequestId();
            int subsequenceId = resultExtras.getSubsequenceId();
            final long frameNumber = resultExtras.getFrameNumber();
            final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
            final CaptureRequest request = holder.getRequest(subsequenceId);
            Runnable failureDispatch = null;
            if (errorCode == 5) {
                final Surface outputSurface = ((OutputConfiguration)CameraDeviceImpl.this.mConfiguredOutputs.get(resultExtras.getErrorStreamId())).getSurface();
                failureDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureBufferLost(CameraDeviceImpl.this, request, outputSurface, frameNumber);
                        }
                    }
                };
            } else {
                boolean mayHaveBuffers = errorCode == 4;
                int reason = CameraDeviceImpl.this.mCurrentSession != null && CameraDeviceImpl.this.mCurrentSession.isAborting() ? 1 : 0;
                final CaptureFailure failure = new CaptureFailure(request, reason, mayHaveBuffers, requestId, frameNumber);
                failureDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureFailed(CameraDeviceImpl.this, request, failure);
                        }
                    }
                };
                CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, true, request.isReprocess());
                CameraDeviceImpl.this.checkAndFireSequenceComplete();
            }
            holder.getHandler().post(failureDispatch);
        }
    }

    public class FrameNumberTracker {
        private long mCompletedFrameNumber = -1L;
        private long mCompletedReprocessFrameNumber = -1L;
        private final LinkedList<Long> mSkippedRegularFrameNumbers = new LinkedList();
        private final LinkedList<Long> mSkippedReprocessFrameNumbers = new LinkedList();
        private final TreeMap<Long, Boolean> mFutureErrorMap = new TreeMap();
        private final HashMap<Long, List<CaptureResult>> mPartialResults = new HashMap();

        private void update() {
            Iterator<Map.Entry<Long, Boolean>> iter = this.mFutureErrorMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, Boolean> pair = iter.next();
                Long errorFrameNumber = pair.getKey();
                Boolean reprocess = pair.getValue();
                Boolean removeError = true;
                if (reprocess.booleanValue()) {
                    if (errorFrameNumber == this.mCompletedReprocessFrameNumber + 1L) {
                        this.mCompletedReprocessFrameNumber = errorFrameNumber;
                    } else if (!this.mSkippedReprocessFrameNumbers.isEmpty() && errorFrameNumber == this.mSkippedReprocessFrameNumbers.element()) {
                        this.mCompletedReprocessFrameNumber = errorFrameNumber;
                        this.mSkippedReprocessFrameNumbers.remove();
                    } else {
                        removeError = false;
                    }
                } else if (errorFrameNumber == this.mCompletedFrameNumber + 1L) {
                    this.mCompletedFrameNumber = errorFrameNumber;
                } else if (!this.mSkippedRegularFrameNumbers.isEmpty() && errorFrameNumber == this.mSkippedRegularFrameNumbers.element()) {
                    this.mCompletedFrameNumber = errorFrameNumber;
                    this.mSkippedRegularFrameNumbers.remove();
                } else {
                    removeError = false;
                }
                if (!removeError.booleanValue()) continue;
                iter.remove();
            }
        }

        public void updateTracker(long frameNumber, boolean isError, boolean isReprocess) {
            if (isError) {
                this.mFutureErrorMap.put(frameNumber, isReprocess);
            } else {
                try {
                    if (isReprocess) {
                        this.updateCompletedReprocessFrameNumber(frameNumber);
                    } else {
                        this.updateCompletedFrameNumber(frameNumber);
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.e(CameraDeviceImpl.this.TAG, e.getMessage());
                }
            }
            this.update();
        }

        public void updateTracker(long frameNumber, CaptureResult result, boolean partial, boolean isReprocess) {
            if (!partial) {
                this.updateTracker(frameNumber, false, isReprocess);
                return;
            }
            if (result == null) {
                return;
            }
            List<CaptureResult> partials = this.mPartialResults.get(frameNumber);
            if (partials == null) {
                partials = new ArrayList<CaptureResult>();
                this.mPartialResults.put(frameNumber, partials);
            }
            partials.add(result);
        }

        public List<CaptureResult> popPartialResults(long frameNumber) {
            return this.mPartialResults.remove(frameNumber);
        }

        public long getCompletedFrameNumber() {
            return this.mCompletedFrameNumber;
        }

        public long getCompletedReprocessFrameNumber() {
            return this.mCompletedReprocessFrameNumber;
        }

        private void updateCompletedFrameNumber(long frameNumber) throws IllegalArgumentException {
            if (frameNumber <= this.mCompletedFrameNumber) {
                throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
            }
            if (frameNumber <= this.mCompletedReprocessFrameNumber) {
                if (this.mSkippedRegularFrameNumbers.isEmpty() || frameNumber < this.mSkippedRegularFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
                }
                if (frameNumber > this.mSkippedRegularFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " comes out of order. Expecting " + this.mSkippedRegularFrameNumbers.element());
                }
                this.mSkippedRegularFrameNumbers.remove();
            } else {
                for (long i = Math.max(this.mCompletedFrameNumber, this.mCompletedReprocessFrameNumber) + 1L; i < frameNumber; ++i) {
                    this.mSkippedReprocessFrameNumbers.add(i);
                }
            }
            this.mCompletedFrameNumber = frameNumber;
        }

        private void updateCompletedReprocessFrameNumber(long frameNumber) throws IllegalArgumentException {
            if (frameNumber < this.mCompletedReprocessFrameNumber) {
                throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
            }
            if (frameNumber < this.mCompletedFrameNumber) {
                if (this.mSkippedReprocessFrameNumbers.isEmpty() || frameNumber < this.mSkippedReprocessFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
                }
                if (frameNumber > this.mSkippedReprocessFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " comes out of order. Expecting " + this.mSkippedReprocessFrameNumbers.element());
                }
                this.mSkippedReprocessFrameNumbers.remove();
            } else {
                for (long i = Math.max(this.mCompletedFrameNumber, this.mCompletedReprocessFrameNumber) + 1L; i < frameNumber; ++i) {
                    this.mSkippedRegularFrameNumbers.add(i);
                }
            }
            this.mCompletedReprocessFrameNumber = frameNumber;
        }
    }

    static class RequestLastFrameNumbersHolder {
        private final int mRequestId;
        private final long mLastRegularFrameNumber;
        private final long mLastReprocessFrameNumber;

        public RequestLastFrameNumbersHolder(List<CaptureRequest> requestList, SubmitInfo requestInfo) {
            long lastRegularFrameNumber = -1L;
            long lastReprocessFrameNumber = -1L;
            long frameNumber = requestInfo.getLastFrameNumber();
            if (requestInfo.getLastFrameNumber() < (long)(requestList.size() - 1)) {
                throw new IllegalArgumentException("lastFrameNumber: " + requestInfo.getLastFrameNumber() + " should be at least " + (requestList.size() - 1) + " for the number of " + " requests in the list: " + requestList.size());
            }
            for (int i = requestList.size() - 1; i >= 0; --i) {
                CaptureRequest request = requestList.get(i);
                if (request.isReprocess() && lastReprocessFrameNumber == -1L) {
                    lastReprocessFrameNumber = frameNumber;
                } else if (!request.isReprocess() && lastRegularFrameNumber == -1L) {
                    lastRegularFrameNumber = frameNumber;
                }
                if (lastReprocessFrameNumber != -1L && lastRegularFrameNumber != -1L) break;
                --frameNumber;
            }
            this.mLastRegularFrameNumber = lastRegularFrameNumber;
            this.mLastReprocessFrameNumber = lastReprocessFrameNumber;
            this.mRequestId = requestInfo.getRequestId();
        }

        public RequestLastFrameNumbersHolder(int requestId, long lastRegularFrameNumber) {
            this.mLastRegularFrameNumber = lastRegularFrameNumber;
            this.mLastReprocessFrameNumber = -1L;
            this.mRequestId = requestId;
        }

        public long getLastRegularFrameNumber() {
            return this.mLastRegularFrameNumber;
        }

        public long getLastReprocessFrameNumber() {
            return this.mLastReprocessFrameNumber;
        }

        public long getLastFrameNumber() {
            return Math.max(this.mLastRegularFrameNumber, this.mLastReprocessFrameNumber);
        }

        public int getRequestId() {
            return this.mRequestId;
        }
    }

    static class CaptureCallbackHolder {
        private final boolean mRepeating;
        private final CaptureCallback mCallback;
        private final List<CaptureRequest> mRequestList;
        private final Handler mHandler;
        private final int mSessionId;

        CaptureCallbackHolder(CaptureCallback callback, List<CaptureRequest> requestList, Handler handler, boolean repeating, int sessionId) {
            if (callback == null || handler == null) {
                throw new UnsupportedOperationException("Must have a valid handler and a valid callback");
            }
            this.mRepeating = repeating;
            this.mHandler = handler;
            this.mRequestList = new ArrayList<CaptureRequest>(requestList);
            this.mCallback = callback;
            this.mSessionId = sessionId;
        }

        public boolean isRepeating() {
            return this.mRepeating;
        }

        public CaptureCallback getCallback() {
            return this.mCallback;
        }

        public CaptureRequest getRequest(int subsequenceId) {
            if (subsequenceId >= this.mRequestList.size()) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is larger than request list size %d.", subsequenceId, this.mRequestList.size()));
            }
            if (subsequenceId < 0) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is negative", subsequenceId));
            }
            return this.mRequestList.get(subsequenceId);
        }

        public CaptureRequest getRequest() {
            return this.getRequest(0);
        }

        public Handler getHandler() {
            return this.mHandler;
        }

        public int getSessionId() {
            return this.mSessionId;
        }
    }

    public static abstract class StateCallbackKK
    extends CameraDevice.StateCallback {
        public void onUnconfigured(CameraDevice camera) {
        }

        public void onActive(CameraDevice camera) {
        }

        public void onBusy(CameraDevice camera) {
        }

        public void onIdle(CameraDevice camera) {
        }

        public void onSurfacePrepared(Surface surface) {
        }
    }

    public static abstract class CaptureCallback {
        public static final int NO_FRAMES_CAPTURED = -1;

        public void onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp, long frameNumber) {
        }

        public void onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
        }

        public void onCaptureProgressed(CameraDevice camera, CaptureRequest request, CaptureResult partialResult) {
        }

        public void onCaptureCompleted(CameraDevice camera, CaptureRequest request, TotalCaptureResult result) {
        }

        public void onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
        }

        public void onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
        }

        public void onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
        }

        public void onCaptureBufferLost(CameraDevice camera, CaptureRequest request, Surface target, long frameNumber) {
        }
    }
}

