/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.FontFamily_Delegate;
import android.graphics.FontListParser;
import android.util.Log;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;

public class FontFamily {
    private static String TAG = "FontFamily";
    public long mNativePtr;

    public FontFamily() {
        this.mNativePtr = FontFamily.nCreateFamily(null, 0);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    public FontFamily(String lang, String variant) {
        int varEnum = 0;
        if ("compact".equals(variant)) {
            varEnum = 1;
        } else if ("elegant".equals(variant)) {
            varEnum = 2;
        }
        this.mNativePtr = FontFamily.nCreateFamily(lang, varEnum);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    protected void finalize() throws Throwable {
        try {
            FontFamily.nUnrefFamily(this.mNativePtr);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFont_Original(String path, int ttcIndex) {
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            boolean bl = FontFamily.nAddFont(this.mNativePtr, fontBuffer, ttcIndex);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    @LayoutlibDelegate
    public boolean addFont(String string2, int n) {
        return FontFamily_Delegate.addFont(this, string2, n);
    }

    public boolean addFontWeightStyle(ByteBuffer font, int ttcIndex, List<FontListParser.Axis> axes, int weight, boolean style2) {
        return FontFamily.nAddFontWeightStyle(this.mNativePtr, font, ttcIndex, axes, weight, style2);
    }

    public boolean addFontFromAsset(AssetManager mgr, String path) {
        return FontFamily.nAddFontFromAsset(this.mNativePtr, mgr, path);
    }

    @LayoutlibDelegate
    private static long nCreateFamily(String string2, int n) {
        return FontFamily_Delegate.nCreateFamily(string2, n);
    }

    @LayoutlibDelegate
    private static void nUnrefFamily(long l) {
        FontFamily_Delegate.nUnrefFamily(l);
    }

    @LayoutlibDelegate
    private static boolean nAddFont(long l, ByteBuffer byteBuffer, int n) {
        return FontFamily_Delegate.nAddFont(l, byteBuffer, n);
    }

    @LayoutlibDelegate
    private static boolean nAddFontWeightStyle(long l, ByteBuffer byteBuffer, int n, List<FontListParser.Axis> list, int n2, boolean bl) {
        return FontFamily_Delegate.nAddFontWeightStyle(l, byteBuffer, n, list, n2, bl);
    }

    @LayoutlibDelegate
    private static boolean nAddFontFromAsset(long l, AssetManager assetManager, String string2) {
        return FontFamily_Delegate.nAddFontFromAsset(l, assetManager, string2);
    }
}

