/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.BridgeTypedArray;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Resources_Theme_Delegate {
    private static final DelegateManager<Resources_Theme_Delegate> sManager = new DelegateManager<Resources_Theme_Delegate>(Resources_Theme_Delegate.class);

    public static DelegateManager<Resources_Theme_Delegate> getDelegateManager() {
        return sManager;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources thisResources, Resources.Theme thisTheme, int[] attrs) {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        BridgeTypedArray ta = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(attrs);
        ta.setTheme(thisTheme);
        Resources_Theme_Delegate.restoreResources(changed);
        return ta;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources thisResources, Resources.Theme thisTheme, int resid, int[] attrs) throws Resources.NotFoundException {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        BridgeTypedArray ta = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(resid, attrs);
        ta.setTheme(thisTheme);
        Resources_Theme_Delegate.restoreResources(changed);
        return ta;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources thisResources, Resources.Theme thisTheme, AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        BridgeTypedArray ta = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(set, attrs, defStyleAttr, defStyleRes);
        ta.setTheme(thisTheme);
        Resources_Theme_Delegate.restoreResources(changed);
        return ta;
    }

    @LayoutlibDelegate
    static boolean resolveAttribute(Resources thisResources, Resources.Theme thisTheme, int resid, TypedValue outValue, boolean resolveRefs) {
        boolean changed = Resources_Theme_Delegate.setupResources(thisTheme);
        boolean found = RenderSessionImpl.getCurrentContext().resolveThemeAttribute(resid, outValue, resolveRefs);
        Resources_Theme_Delegate.restoreResources(changed);
        return found;
    }

    @LayoutlibDelegate
    static TypedArray resolveAttributes(Resources thisResources, Resources.Theme thisTheme, int[] values, int[] attrs) {
        return null;
    }

    private static boolean setupResources(Resources.Theme thisTheme) {
        Resources.ThemeKey key = thisTheme.getKey();
        int[] resId = key.mResId;
        boolean[] force = key.mForce;
        boolean changed = false;
        int N = key.mCount;
        for (int i = 0; i < N; ++i) {
            StyleResourceValue style2 = Resources_Theme_Delegate.resolveStyle(resId[i]);
            if (style2 == null) continue;
            RenderSessionImpl.getCurrentContext().getRenderResources().applyStyle(style2, force[i]);
            changed = true;
        }
        return changed;
    }

    private static void restoreResources(boolean changed) {
        if (changed) {
            RenderSessionImpl.getCurrentContext().getRenderResources().clearStyles();
        }
    }

    private static StyleResourceValue resolveStyle(int nativeResid) {
        if (nativeResid == 0) {
            return null;
        }
        BridgeContext context = RenderSessionImpl.getCurrentContext();
        ResourceReference theme = context.resolveId(nativeResid);
        if (theme.isFramework()) {
            return (StyleResourceValue)context.getRenderResources().getFrameworkResource(ResourceType.STYLE, theme.getName());
        }
        return (StyleResourceValue)context.getRenderResources().getProjectResource(ResourceType.STYLE, theme.getName());
    }
}

