/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.highlighting.AbstractManifestQuickFix;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.jetbrains.lang.manifest.psi.Section;

public class MissingFinalNewlineInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String text;
        if (file2 instanceof ManifestFile && (text = file2.getText()) != null && text.length() > 0 && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            List<Section> sections = ((ManifestFile)file2).getSections();
            assert (sections.size() > 0) : text;
            Section section = sections.get(sections.size() - 1);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(section.getLastChild(), ManifestBundle.message("inspection.newline.message", new Object[0]), (LocalQuickFix)new AddNewlineQuickFix(section), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private static class AddNewlineQuickFix
    extends AbstractManifestQuickFix {
        private AddNewlineQuickFix(Section section) {
            super(section);
        }

        @NotNull
        public String getText() {
            return ManifestBundle.message("inspection.newline.fix", new Object[0]);
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement lastChild = startElement.getLastChild();
            if (lastChild instanceof Header) {
                lastChild.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
            }
        }
    }
}

