/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserProvider;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class HeaderParserRepository {
    private final NotNullLazyValue<Map<String, HeaderParser>> myParsers = new NotNullLazyValue<Map<String, HeaderParser>>(){

        @NotNull
        protected Map<String, HeaderParser> compute() {
            THashMap map = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (HeaderParserProvider provider : (HeaderParserProvider[])Extensions.getExtensions(HeaderParserProvider.EP_NAME)) {
                map.putAll(provider.getHeaderParsers());
            }
            return map;
        }
    };

    public static HeaderParserRepository getInstance() {
        return (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
    }

    @Nullable
    public HeaderParser getHeaderParser(@Nullable String headerName) {
        return (HeaderParser)((Map)this.myParsers.getValue()).get(headerName);
    }

    @NotNull
    public Set<String> getAllHeaderNames() {
        return ((Map)this.myParsers.getValue()).keySet();
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        HeaderParser parser = this.getHeaderParser(header.getName());
        return parser != null ? parser.getConvertedValue(header) : null;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        HeaderParser parser;
        Header header = (Header)PsiTreeUtil.getParentOfType((PsiElement)headerValuePart, Header.class);
        if (header != null && (parser = this.getHeaderParser(header.getName())) != null) {
            return parser.getReferences(headerValuePart);
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

