/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.ChannelBufferToString;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;

@ChannelHandler.Sharable
final class MessageChannelHandler
extends SimpleChannelInboundHandlerAdapter<WebSocketFrame> {
    private final ClientManager clientManager;
    private final MessageServer messageServer;

    MessageChannelHandler(@NotNull ClientManager clientManager, @NotNull MessageServer messageServer) {
        this.clientManager = clientManager;
        this.messageServer = messageServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceived(ChannelHandlerContext context, WebSocketFrame message) throws Exception {
        WebSocketClient client = (WebSocketClient)((Object)context.attr(ClientManagerKt.getCLIENT()).get());
        if (message instanceof CloseWebSocketFrame) {
            if (client != null) {
                try {
                    this.clientManager.disconnectClient(context, client, false);
                }
                finally {
                    message.retain();
                    client.disconnect((CloseWebSocketFrame)message);
                }
            }
        } else if (message instanceof PingWebSocketFrame) {
            context.channel().writeAndFlush((Object)new PongWebSocketFrame(message.content()));
        } else if (message instanceof TextWebSocketFrame) {
            try {
                this.messageServer.messageReceived(client, ChannelBufferToString.readChars(message.content()));
            }
            catch (Throwable e) {
                this.clientManager.getExceptionHandler().exceptionCaught(e);
            }
        } else if (!(message instanceof PongWebSocketFrame)) {
            throw new UnsupportedOperationException(message.getClass().getName() + " frame types not supported");
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Client client = (Client)((Object)context.attr(ClientManagerKt.getCLIENT()).get());
        if (client != null) {
            this.clientManager.disconnectClient(context, client, false);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        try {
            this.clientManager.getExceptionHandler().exceptionCaught(cause);
        }
        finally {
            context.channel().close();
        }
    }
}

