/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Responses {
    private static String SERVER_HEADER_VALUE;

    public static FullHttpResponse response(HttpResponseStatus status) {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.EMPTY_BUFFER);
    }

    @NotNull
    public static FullHttpResponse response(@Nullable String contentType, @Nullable ByteBuf content) {
        DefaultFullHttpResponse response;
        DefaultFullHttpResponse defaultFullHttpResponse = response = content == null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        if (contentType != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        return response;
    }

    public static void setDate(@NotNull HttpResponse response) {
        if (!response.headers().contains((CharSequence)HttpHeaderNames.DATE)) {
            response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)Calendar.getInstance().getTime());
        }
    }

    public static void addNoCache(@NotNull HttpResponse response) {
        response.headers().add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache, no-store, must-revalidate, max-age=0");
        response.headers().add((CharSequence)HttpHeaderNames.PRAGMA, (Object)"no-cache");
    }

    @Nullable
    public static String getServerHeaderValue() {
        Application app;
        if (SERVER_HEADER_VALUE == null && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            SERVER_HEADER_VALUE = ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        }
        return SERVER_HEADER_VALUE;
    }

    public static void addServer(@NotNull HttpResponse response) {
        if (Responses.getServerHeaderValue() != null) {
            response.headers().add((CharSequence)HttpHeaderNames.SERVER, (Object)Responses.getServerHeaderValue());
        }
    }

    public static void send(@NotNull HttpResponse response, Channel channel, @Nullable HttpRequest request) {
        Responses.send(response, channel, request, null);
    }

    public static void send(@NotNull HttpResponse response, Channel channel, @Nullable HttpRequest request, @Nullable HttpHeaders extraHeaders) {
        if (response.status() != HttpResponseStatus.NOT_MODIFIED && !HttpUtil.isContentLengthSet((HttpMessage)response)) {
            HttpUtil.setContentLength((HttpMessage)response, (long)(response instanceof FullHttpResponse ? (long)((FullHttpResponse)response).content().readableBytes() : 0L));
        }
        Responses.addCommonHeaders(response);
        if (extraHeaders != null) {
            response.headers().add(extraHeaders);
        }
        Responses.send(response, channel, request != null && !Responses.addKeepAliveIfNeed(response, request));
    }

    public static boolean addKeepAliveIfNeed(HttpResponse response, HttpRequest request) {
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
            return true;
        }
        return false;
    }

    public static void addCommonHeaders(@NotNull HttpResponse response) {
        Responses.addServer(response);
        Responses.setDate(response);
        if (!response.headers().contains("X-Frame-Options")) {
            response.headers().set("X-Frame-Options", (Object)"SameOrigin");
        }
        response.headers().set("X-Content-Type-Options", (Object)"nosniff");
        response.headers().set("x-xss-protection", (Object)"1; mode=block");
    }

    public static void send(CharSequence content, Channel channel, @Nullable HttpRequest request) {
        Responses.send(content, CharsetUtil.US_ASCII, channel, request);
    }

    public static void send(CharSequence content, Charset charset, Channel channel, @Nullable HttpRequest request) {
        Responses.send((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)charset)), channel, request, null);
    }

    public static void send(@NotNull HttpResponse response, @NotNull Channel channel, boolean close) {
        if (!channel.isActive()) {
            return;
        }
        ChannelFuture future2 = channel.write((Object)response);
        if (!(response instanceof FullHttpResponse)) {
            channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        channel.flush();
        if (close) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static void sendStatus(HttpResponseStatus responseStatus, Channel channel) {
        Responses.sendStatus(responseStatus, channel, null);
    }

    public static void sendStatus(HttpResponseStatus responseStatus, Channel channel, @Nullable HttpRequest request) {
        Responses.sendStatus(responseStatus, channel, null, request);
    }

    public static HttpResponseStatus okInSafeMode(@NotNull HttpResponseStatus status) {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode() ? status : HttpResponseStatus.OK;
    }

    public static void sendStatus(@NotNull HttpResponseStatus responseStatus, Channel channel, @Nullable String description, @Nullable HttpRequest request) {
        Responses.sendStatus(responseStatus, channel, description, request, null);
    }

    public static void sendStatus(@NotNull HttpResponseStatus responseStatus, Channel channel, @Nullable String description, @Nullable HttpRequest request, @Nullable HttpHeaders extraHeaders) {
        Responses.send(Responses.createStatusResponse(responseStatus, request, description), channel, request, extraHeaders);
    }

    public static void sendUnauthorizedAuthenticate(ChannelHandlerContext context, HttpRequest request, String realm) {
        HttpResponse response = Responses.createStatusResponse(HttpResponseStatus.UNAUTHORIZED, request, "Unauthorized");
        response.headers().add("WWW-Authenticate", (Object)String.format("Basic realm=\"%s\"", realm));
        Responses.send(response, context.channel(), request);
    }

    private static HttpResponse createStatusResponse(HttpResponseStatus responseStatus, @Nullable HttpRequest request, @Nullable String description) {
        if (request != null && request.method() == HttpMethod.HEAD) {
            return Responses.response(responseStatus);
        }
        StringBuilder builder = new StringBuilder();
        String message = responseStatus.toString();
        builder.append("<!doctype html><title>").append(message).append("</title>").append("<h1 style=\"text-align: center\">").append(message).append("</h1>");
        if (description != null) {
            builder.append("<p>").append(description).append("</p>");
        }
        builder.append("<hr/><p style=\"text-align: center\">").append(StringUtil.notNullize((String)Responses.getServerHeaderValue(), (String)"")).append("</p>");
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(builder), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        return response;
    }
}

