/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyKt;

public final class NettyUtil {
    public static final int MAX_CONTENT_LENGTH = 0x6400000;
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void logAndClose(@NotNull Throwable error, @NotNull Logger log, @NotNull Channel channel) {
        try {
            if (error instanceof ConnectException) {
                log.debug(error);
            } else {
                NettyUtil.log(error, log);
            }
        }
        finally {
            log.info("Channel will be closed due to error");
            channel.close();
        }
    }

    public static void log(@NotNull Throwable throwable, @NotNull Logger log) {
        if (NettyUtil.isAsWarning(throwable)) {
            log.warn(throwable);
        } else {
            log.error(throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static Channel doConnect(@NotNull Bootstrap bootstrap, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @NotNull Condition<Void> stopCondition) throws Throwable {
        Socket socket;
        int attemptCount = 0;
        if (bootstrap.group() instanceof NioEventLoopGroup) {
            return NettyUtil.connectNio(bootstrap, remoteAddress, promise2, maxAttemptCount, stopCondition, attemptCount);
        }
        bootstrap.validate();
        while (true) {
            try {
                socket = new Socket(remoteAddress.getAddress(), remoteAddress.getPort());
            }
            catch (IOException e) {
                if (stopCondition.value(null) || promise2 != null && promise2.getState() != Promise.State.PENDING) {
                    return null;
                }
                if (maxAttemptCount == -1) {
                    if (NettyUtil.sleep(promise2, 300)) {
                        return null;
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount < maxAttemptCount) {
                    if (NettyUtil.sleep(promise2, attemptCount * 100)) return null;
                    continue;
                }
                if (promise2 == null) return null;
                promise2.setError((Throwable)e);
                return null;
            }
            break;
        }
        OioSocketChannel channel = new OioSocketChannel(socket);
        BootstrapUtil.initAndRegister((Channel)channel, bootstrap).sync();
        return channel;
    }

    @Nullable
    private static Channel connectNio(@NotNull Bootstrap bootstrap, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @NotNull Condition<Void> stopCondition, int attemptCount) {
        ChannelFuture future2;
        block8: {
            while (true) {
                if ((future2 = bootstrap.connect((SocketAddress)remoteAddress).awaitUninterruptibly()).isSuccess()) {
                    if (!future2.channel().isOpen()) continue;
                    return future2.channel();
                }
                if (stopCondition.value(null) || promise2 != null && promise2.getState() == Promise.State.REJECTED) {
                    return null;
                }
                if (maxAttemptCount == -1) {
                    if (NettyUtil.sleep(promise2, 300)) {
                        return null;
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount >= maxAttemptCount) break block8;
                if (NettyUtil.sleep(promise2, attemptCount * 100)) break;
            }
            return null;
        }
        Throwable cause = future2.cause();
        if (promise2 != null) {
            if (cause == null) {
                promise2.setError("Cannot connect: unknown error");
            } else {
                promise2.setError(cause);
            }
        }
        return null;
    }

    private static boolean sleep(@Nullable AsyncPromise<?> promise2, int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ignored) {
            if (promise2 != null) {
                promise2.setError("Interrupted");
            }
            return true;
        }
        return false;
    }

    private static boolean isAsWarning(@NotNull Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        return throwable instanceof IOException && message.equals("An existing connection was forcibly closed by the remote host") || throwable instanceof ChannelException && message.startsWith("Failed to bind to: ") || throwable instanceof BindException || message.startsWith("Connection reset") || message.equals("Operation timed out") || message.equals("Connection timed out");
    }

    @Deprecated
    @NotNull
    public static ServerBootstrap nioServerBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(NioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    @Deprecated
    @NotNull
    public static Bootstrap oioClientBootstrap() {
        return NettyKt.oioClientBootstrap();
    }

    public static Bootstrap nioClientBootstrap() {
        return NettyUtil.nioClientBootstrap((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE));
    }

    public static Bootstrap nioClientBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static void addHttpServerCodec(@NotNull ChannelPipeline pipeline) {
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder(16384, 16384, 8192));
        pipeline.addLast("httpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
        if (pipeline.get(ChunkedWriteHandler.class) == null) {
            pipeline.addLast("chunkedWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
        }
        pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandlerDoNotUseOwnLogger(CorsConfig.withAnyOrigin().allowCredentials().allowNullOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.PATCH}).allowedRequestHeaders(new String[]{"origin", "accept", "authorization", "content-type"}).build()));
    }

    public static void awaitQuiescenceOfGlobalEventExecutor(long timeout, @NotNull TimeUnit unit) {
        try {
            GlobalEventExecutor executor = GlobalEventExecutor.INSTANCE;
            executor.awaitInactivity(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static final class CorsHandlerDoNotUseOwnLogger
    extends CorsHandler {
        public CorsHandlerDoNotUseOwnLogger(@NotNull CorsConfig config) {
            super(config);
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            context.fireExceptionCaught(cause);
        }
    }
}

