/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelBufferToString;
import org.jetbrains.io.CharSequenceBackedByChars;
import org.jetbrains.io.Decoder;

public abstract class MessageDecoder
extends Decoder {
    protected int contentLength;
    protected final StringBuilder builder = new StringBuilder(64);
    private CharBuffer chunkedContent;
    private int consumedContentByteCount = 0;

    protected final int parseContentLength() {
        return MessageDecoder.parseInt(this.builder, 0, false, 10);
    }

    @Nullable
    protected final CharSequence readChars(@NotNull ByteBuf input) throws IOException {
        int readableBytes = input.readableBytes();
        if (readableBytes == 0) {
            input.release();
            return null;
        }
        int required = this.contentLength - this.consumedContentByteCount;
        if (readableBytes < required) {
            if (this.chunkedContent == null) {
                this.chunkedContent = CharBuffer.allocate(this.contentLength);
            }
            ChannelBufferToString.readIntoCharBuffer(input, readableBytes, this.chunkedContent);
            this.consumedContentByteCount += readableBytes;
            input.release();
            return null;
        }
        CharBuffer charBuffer = this.chunkedContent;
        if (charBuffer != null) {
            this.chunkedContent = null;
            this.consumedContentByteCount = 0;
        }
        return new CharSequenceBackedByChars(ChannelBufferToString.readIntoCharBuffer(input, required, charBuffer));
    }

    @Override
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        try {
            this.chunkedContent = null;
        }
        finally {
            super.channelInactive(context);
        }
    }

    public static boolean readUntil(char what, @NotNull ByteBuf buffer, @NotNull StringBuilder builder) {
        int i;
        int n = buffer.writerIndex();
        for (i = buffer.readerIndex(); i < n; ++i) {
            char c = (char)buffer.getByte(i);
            if (c == what) {
                buffer.readerIndex(i + 1);
                return true;
            }
            builder.append(c);
        }
        buffer.readerIndex(i);
        return false;
    }

    public static void skipWhitespace(@NotNull ByteBuf buffer) {
        int n = buffer.writerIndex();
        for (int i = buffer.readerIndex(); i < n; ++i) {
            char c = (char)buffer.getByte(i);
            if (c == ' ') continue;
            buffer.readerIndex(i);
            return;
        }
        buffer.readerIndex(n);
    }

    public static int parseInt(@NotNull CharSequence value, int start, boolean isNegative, int radix) {
        int i;
        int end = value.length();
        int result = 0;
        for (i = start; i < end; ++i) {
            int digit;
            char c = value.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit < 0 || digit >= radix) break;
            int newResult = result * radix - digit;
            if (newResult > result) {
                throw new NumberFormatException("Overflow parsing " + value.subSequence(start, end));
            }
            result = newResult;
        }
        if (result == 0 && (end == 0 || value.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + value.subSequence(start, end));
        }
        if (result == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + value.subSequence(start, end));
        }
        return isNegative ? result : -result;
    }
}

