/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import javax.activation.MimetypesFileTypeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.Responses;

public class FileResponses {
    private static final MimetypesFileTypeMap FILE_MIMETYPE_MAP = new MimetypesFileTypeMap();

    public static String getContentType(String path) {
        return FILE_MIMETYPE_MAP.getContentType(path);
    }

    private static boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @Nullable HttpHeaders extraHeaders) {
        Long ifModified = request.headers().getTimeMillis((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModified != null && ifModified >= lastModified) {
            Responses.send((HttpResponse)Responses.response(HttpResponseStatus.NOT_MODIFIED), channel, request, extraHeaders);
            return true;
        }
        return false;
    }

    @Nullable
    public static HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String path, @Nullable HttpHeaders extraHeaders) {
        if (FileResponses.checkCache(request, channel, lastModified, extraHeaders)) {
            return null;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)FileResponses.getContentType(path));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
        if (extraHeaders != null) {
            response.headers().add(extraHeaders);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull File file2, @Nullable HttpHeaders extraHeaders) throws IOException {
        RandomAccessFile raf;
        HttpResponse response = FileResponses.prepareSend(request, channel, file2.lastModified(), file2.getPath(), extraHeaders);
        if (response == null) {
            return;
        }
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, request);
        boolean fileWillBeClosed = false;
        try {
            raf = new RandomAccessFile(file2, "r");
        }
        catch (FileNotFoundException ignored) {
            Responses.send((HttpResponse)Responses.response(HttpResponseStatus.NOT_FOUND), channel, request, extraHeaders);
            return;
        }
        try {
            long fileLength = raf.length();
            HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                if (channel.pipeline().get(SslHandler.class) == null) {
                    channel.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
                } else {
                    channel.write((Object)new ChunkedFile(raf));
                }
            }
            fileWillBeClosed = true;
        }
        finally {
            if (!fileWillBeClosed) {
                raf.close();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

