/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.common.base.Strings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.Base64;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.ui.UIUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.Responses;

@ChannelHandler.Sharable
final class DelegatingHttpRequestHandler
extends DelegatingHttpRequestHandlerBase {
    private static final AttributeKey<HttpRequestHandler> PREV_HANDLER = AttributeKey.valueOf((String)"DelegatingHttpRequestHandler.handler");
    private static final Logger LOG = Logger.getInstance(DelegatingHttpRequestHandler.class);

    DelegatingHttpRequestHandler() {
    }

    static boolean checkAndProcess(@NotNull HttpRequestHandler handler2, @NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws IOException {
        return handler2.isSupported(request) && !NettyKt.isWriteFromBrowserWithoutOrigin((HttpRequest)request) && handler2.isAccessible((HttpRequest)request) && handler2.process(urlDecoder, request, context);
    }

    @Override
    protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws IOException, ImageWriteException {
        Icon icon;
        if (!this.authenticateAndUpdateUrlIfNeeded(request)) {
            String product = ApplicationInfoEx.getInstance().getVersionName();
            Responses.sendUnauthorizedAuthenticate(context, (HttpRequest)request, product);
            return true;
        }
        urlDecoder = new QueryStringDecoder(request.uri());
        Attribute prevHandlerAttribute = context.attr(PREV_HANDLER);
        HttpRequestHandler connectedHandler = (HttpRequestHandler)prevHandlerAttribute.get();
        if (connectedHandler != null) {
            if (DelegatingHttpRequestHandler.checkAndProcess(connectedHandler, context, request, urlDecoder)) {
                return true;
            }
            prevHandlerAttribute.set(null);
        }
        for (HttpRequestHandler handler2 : (HttpRequestHandler[])HttpRequestHandler.EP_NAME.getExtensions()) {
            try {
                if (!DelegatingHttpRequestHandler.checkAndProcess(handler2, context, request, urlDecoder)) continue;
                prevHandlerAttribute.set((Object)handler2);
                return true;
            }
            catch (Throwable e) {
                Logger.getInstance(BuiltInServer.class).error(e);
            }
        }
        if (urlDecoder.path().equals("/favicon.ico") && (icon = IconLoader.findIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl())) != null) {
            BufferedImage image = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
            icon.paintIcon(null, image.getGraphics(), 0, 0);
            byte[] icoBytes = Sanselan.writeImageToBytes((BufferedImage)image, (ImageFormat)ImageFormat.IMAGE_FORMAT_ICO, null);
            FullHttpResponse response = Responses.response(FileResponses.getContentType(urlDecoder.path()), Unpooled.wrappedBuffer((byte[])icoBytes));
            Responses.addNoCache((HttpResponse)response);
            Responses.send((HttpResponse)response, context.channel(), (HttpRequest)request);
            return true;
        }
        return false;
    }

    private boolean authenticateAndUpdateUrlIfNeeded(@NotNull FullHttpRequest request) {
        if (request.uri().equals("/favicon.ico")) {
            return true;
        }
        String expectedToken = null;
        try {
            expectedToken = BuiltinWebServerAccess.getUserAuthenticationToken();
        }
        catch (IOException e) {
            LOG.error("Unable to read user authentication token", (Throwable)e);
            return false;
        }
        String receivedToken = this.getTokenFromAuthorization(request);
        if (receivedToken != null) {
            return expectedToken.equals(receivedToken);
        }
        return this.authenticateOnUrlAndUpdateUrl(request, expectedToken);
    }

    private boolean authenticateOnUrlAndUpdateUrl(@NotNull FullHttpRequest request, @NotNull String expectedToken) {
        String prefix;
        String uri = request.uri();
        if (uri.startsWith(prefix = "/" + expectedToken + "/")) {
            uri = uri.substring(prefix.length() - 1);
            request.setUri(uri);
            return true;
        }
        return false;
    }

    private String getTokenFromAuthorization(@NotNull FullHttpRequest request) {
        String authorization = request.headers().get("Authorization");
        if (Strings.isNullOrEmpty((String)authorization)) {
            return null;
        }
        if (!authorization.startsWith("Basic ") || authorization.length() < 7) {
            LOG.warn(String.format("Invalid authorization header '%s', unexpected type.", authorization));
            return null;
        }
        String base64 = authorization.substring(6);
        String decoded = null;
        try {
            decoded = new String(Base64.decode((String)base64));
        }
        catch (IllegalArgumentException e) {
            LOG.warn(String.format("Invalid authorization header '%s', bad base64 encoding.", authorization));
            return null;
        }
        String[] parts = decoded.split(":");
        if (parts.length != 2) {
            LOG.warn(String.format("Invalid authorization header '%s', bad username/password pair.", authorization));
            return null;
        }
        String username = parts[0];
        String password = parts[1];
        if (!"_token_".equals(username)) {
            LOG.warn(String.format("Invalid authorization header '%s'", authorization));
            return null;
        }
        return password;
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        try {
            context.attr(PREV_HANDLER).remove();
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

