/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.io.IOException;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.CharSequenceBackedByChars;

public final class ChannelBufferToString {
    @NotNull
    public static CharSequence readChars(@NotNull ByteBuf buffer) throws IOException {
        return new CharSequenceBackedByChars(ChannelBufferToString.readIntoCharBuffer(buffer, buffer.readableBytes(), null));
    }

    @NotNull
    public static CharSequence readChars(@NotNull ByteBuf buffer, int byteCount) throws IOException {
        return new CharSequenceBackedByChars(ChannelBufferToString.readIntoCharBuffer(buffer, byteCount, null));
    }

    @NotNull
    public static CharBuffer readIntoCharBuffer(@NotNull ByteBuf buffer, int byteCount, @Nullable CharBuffer charBuffer) throws IOException {
        if (charBuffer == null) {
            charBuffer = CharBuffer.allocate(byteCount);
        }
        ByteBufUtilEx.readUtf8(buffer, byteCount, charBuffer);
        return charBuffer;
    }

    public static void writeIntAsAscii(int value, @NotNull ByteBuf buffer) {
        ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)new StringBuilder().append(value));
    }
}

