/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide.script;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class Jsr223IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManager.class);
    private final Future<ScriptEngineManager> myManagerFuture = PooledThreadExecutor.INSTANCE.submit(new Callable<ScriptEngineManager>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScriptEngineManager call() {
            long start = System.currentTimeMillis();
            try {
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                return scriptEngineManager;
            }
            finally {
                long end = System.currentTimeMillis();
                LOG.info(ScriptEngineManager.class.getName() + " initialized in " + (end - start) + " ms");
            }
        }
    });

    Jsr223IdeScriptEngineManagerImpl() {
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return ContainerUtil.map(this.getScriptEngineManager().getEngineFactories(), (Function)new Function<ScriptEngineFactory, String>(){

            public String fun(ScriptEngineFactory factory) {
                return factory.getLanguageName();
            }
        });
    }

    @Override
    @NotNull
    public List<String> getFileExtensions(@Nullable String language) {
        ArrayList extensions = ContainerUtil.newArrayList();
        List<ScriptEngineFactory> factories = this.getScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            if (language != null && !factory.getLanguageName().equals(language)) continue;
            extensions.addAll(factory.getExtensions());
        }
        return extensions;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForLanguage(final @NotNull String language, @Nullable ClassLoader loader) {
        ClassLoader l = (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE);
        return (IdeScriptEngine)ClassLoaderUtil.runWithClassLoader((ClassLoader)l, (Computable)new Computable<IdeScriptEngine>(){

            public IdeScriptEngine compute() {
                return Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(Jsr223IdeScriptEngineManagerImpl.this.getScriptEngineManager().getEngineByName(language));
            }
        });
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForFileExtension(final @NotNull String extension, @Nullable ClassLoader loader) {
        ClassLoader l = (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE);
        return (IdeScriptEngine)ClassLoaderUtil.runWithClassLoader((ClassLoader)l, (Computable)new Computable<IdeScriptEngine>(){

            public IdeScriptEngine compute() {
                return Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(Jsr223IdeScriptEngineManagerImpl.this.getScriptEngineManager().getEngineByExtension(extension));
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.myManagerFuture.isDone();
    }

    @NotNull
    private ScriptEngineManager getScriptEngineManager() {
        ScriptEngineManager manager = null;
        try {
            manager = this.myManagerFuture.get();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return (ScriptEngineManager)ObjectUtils.assertNotNull((Object)manager);
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngine engine) {
        return engine == null ? null : Jsr223IdeScriptEngineManagerImpl.redirectOutputToLog(new Jsr223IdeScriptEngine(engine));
    }

    private static IdeScriptEngine redirectOutputToLog(IdeScriptEngine engine) {
        engine.setStdOut(new MyAbstractWriter(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                LOG.info(new String(cbuf, off, len));
            }
        });
        engine.setStdErr(new MyAbstractWriter(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                LOG.warn(new String(cbuf, off, len));
            }
        });
        return engine;
    }

    static class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final Map<Long, ClassLoader> myLuckyGuess = ContainerUtil.newConcurrentMap();

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            int p1 = p0 > 0 ? name.indexOf("$", p0 + 1) : -1;
            String base = p0 > 0 ? name.substring(0, Math.max(p0, p1)) : name;
            long hash = StringHash.calc((String)base);
            ClassLoader loader = this.myLuckyGuess.get(hash);
            if (loader == this) {
                throw new ClassNotFoundException(name);
            }
            Class<?> c = null;
            if (loader != null) {
                try {
                    c = loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                boolean first = true;
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor.getPluginClassLoader();
                    if (l == null || l == loader) continue;
                    try {
                        l.loadClass(base);
                        if (first) {
                            this.myLuckyGuess.put(hash, l);
                        }
                        first = false;
                        try {
                            c = l.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            if (p0 > 0 || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (first && loader == null) {
                    this.myLuckyGuess.put(hash, this);
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.put(StringHash.calc((String)name), this);
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.getClass().getClassLoader().getResources(name);
        }
    }

    private static abstract class MyAbstractWriter
    extends Writer {
        private MyAbstractWriter() {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class Jsr223IdeScriptEngine
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        Jsr223IdeScriptEngine(ScriptEngine engine) {
            this.myEngine = engine;
            this.myLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Object getBinding(@NotNull String name) {
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value) {
            this.myEngine.put(name, value);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            return this.myEngine.getContext().getWriter();
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            return this.myEngine.getContext().getErrorWriter();
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            return this.myEngine.getContext().getReader();
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            return this.myEngine.getFactory().getLanguageName();
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            return this.myEngine.getFactory().getExtensions();
        }

        @Override
        public Object eval(final @NotNull String script) throws IdeScriptException {
            return ClassLoaderUtil.runWithClassLoader((ClassLoader)this.myLoader, (ThrowableComputable)new ThrowableComputable<Object, IdeScriptException>(){

                public Object compute() throws IdeScriptException {
                    try {
                        return Jsr223IdeScriptEngine.this.myEngine.eval(script);
                    }
                    catch (Throwable e) {
                        throw new IdeScriptException(e);
                    }
                }
            });
        }
    }
}

