/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

public class AboutHttpService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        return "about";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        return method == HttpMethod.GET;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        AboutHttpService.getAbout((OutputStream)byteOut, urlDecoder);
        AboutHttpService.send(byteOut, (HttpRequest)request, context);
        return null;
    }

    public static void getAbout(@NotNull OutputStream out, @Nullable QueryStringDecoder urlDecoder) throws IOException {
        BuildNumber build = ApplicationInfo.getInstance().getBuild();
        JsonWriter writer = AboutHttpService.createJsonWriter(out);
        writer.beginObject();
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String appName = appInfo.getFullApplicationName();
        if (!PlatformUtils.isIdeaUltimate()) {
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            appName = appName.replace(productName + " (" + productName + ")", productName);
            appName = StringUtil.trimStart((String)appName, (String)"JetBrains ");
        }
        writer.name("name").value(appName);
        writer.name("productName").value(ApplicationNamesInfo.getInstance().getProductName());
        writer.name("baselineVersion").value((long)build.getBaselineVersion());
        if (build.getBuildNumber() != Integer.MAX_VALUE) {
            writer.name("buildNumber").value((long)build.getBuildNumber());
        }
        if (urlDecoder != null && AboutHttpService.getBooleanParameter("registeredFileTypes", urlDecoder)) {
            writer.name("registeredFileTypes").beginArray();
            for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                writer.beginObject();
                writer.name("name").value(fileType.getName());
                writer.name("description").value(fileType.getDescription());
                writer.name("isBinary").value(fileType.isBinary());
                writer.endObject();
            }
            writer.endArray();
        }
        if (urlDecoder != null && AboutHttpService.getBooleanParameter("more", urlDecoder)) {
            writer.name("vendor").value(appInfo.getCompanyName());
            writer.name("isEAP").value(appInfo.isEAP());
            writer.name("productCode").value(appInfo.getBuild().getProductCode());
            writer.name("buildDate").value(appInfo.getBuildDate().getTime().getTime());
            writer.name("isSnapshot").value(appInfo.getBuild().isSnapshot());
            writer.name("configPath").value(PathManager.getConfigPath());
            writer.name("systemPath").value(PathManager.getSystemPath());
            writer.name("binPath").value(PathManager.getBinPath());
            writer.name("logPath").value(PathManager.getLogPath());
            writer.name("homePath").value(PathManager.getHomePath());
        }
        writer.endObject();
        writer.close();
    }
}

