/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import org.jetbrains.annotations.NotNull;

public enum ValueType {
    OBJECT,
    NUMBER,
    STRING,
    FUNCTION,
    BOOLEAN,
    ARRAY,
    NODE,
    UNDEFINED,
    NULL;

    private static final ValueType[] VALUE_TYPES;

    @NotNull
    public static ValueType fromIndex(int index) {
        return VALUE_TYPES[index];
    }

    public boolean isObjectType() {
        return this == OBJECT || this == ARRAY || this == FUNCTION || this == NODE;
    }

    static {
        VALUE_TYPES = ValueType.values();
    }
}

