/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.VariableContext;

class VariableContextWrapper
implements VariableContext {
    private final VariableContext parentContext;
    private final Scope scope;
    private final NotNullLazyValue<Promise<MemberFilter>> memberFilterPromise = new AtomicNotNullLazyValue<Promise<MemberFilter>>(){

        @NotNull
        protected Promise<MemberFilter> compute() {
            return VariableContextWrapper.this.parentContext.getViewSupport().getMemberFilter(VariableContextWrapper.this);
        }
    };

    public VariableContextWrapper(@NotNull VariableContext parentContext, @Nullable Scope scope) {
        this.parentContext = parentContext;
        this.scope = scope;
    }

    @Override
    @Nullable
    public String getName() {
        return this.parentContext.getName();
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return (Promise)this.memberFilterPromise.getValue();
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.parentContext.getEvaluateContext();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.parentContext.getViewSupport();
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.parentContext.watchableAsEvaluationExpression();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return this.parentContext;
    }
}

