/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PortField;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggableRunConfiguration;

public abstract class RemoteDebugConfiguration
extends LocatableConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction,
DebuggableRunConfiguration {
    private final SerializationFilter serializationFilter = new SkipEmptySerializationFilter(){

        protected ThreeState accepts(@NotNull String name, @NotNull Object beanValue) {
            return name.equals("port") ? ThreeState.fromBoolean((!beanValue.equals(RemoteDebugConfiguration.this.defaultPort) ? 1 : 0) != 0) : ThreeState.UNSURE;
        }
    };
    private String host;
    private int port;
    private final int defaultPort;

    public RemoteDebugConfiguration(Project project2, @NotNull ConfigurationFactory factory, String name, int defaultPort) {
        super(project2, factory, name);
        this.port = defaultPort;
        this.defaultPort = defaultPort;
    }

    @Attribute
    @Nullable
    public String getHost() {
        return this.host;
    }

    public void setHost(@Nullable String value) {
        this.host = StringUtil.isEmpty((String)value) || value.equals("localhost") || value.equals("127.0.0.1") ? null : value;
    }

    @Attribute
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new RemoteDebugConfigurationSettingsEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        return EmptyRunProfileState.INSTANCE;
    }

    public RunConfiguration clone() {
        RemoteDebugConfiguration configuration = (RemoteDebugConfiguration)super.clone();
        configuration.host = this.host;
        configuration.port = this.port;
        return configuration;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        if (this.port <= 0) {
            this.port = this.defaultPort;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)this.serializationFilter);
    }

    @Override
    @NotNull
    public InetSocketAddress computeDebugAddress() {
        if (this.host == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port);
        }
        return new InetSocketAddress(this.host, this.getPort());
    }

    private final class RemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<RemoteDebugConfiguration> {
        private final JTextField hostField = GuiUtils.createUndoableTextField();
        private final PortField portField;

        public RemoteDebugConfigurationSettingsEditor() {
            this.portField = new PortField(RemoteDebugConfiguration.this.defaultPort, 1024);
        }

        protected void resetEditorFrom(RemoteDebugConfiguration configuration) {
            this.hostField.setText(StringUtil.notNullize((String)configuration.host, (String)"localhost"));
            this.portField.setNumber(configuration.port);
        }

        protected void applyEditorTo(RemoteDebugConfiguration configuration) {
            configuration.setHost(this.hostField.getText());
            configuration.setPort(this.portField.getNumber());
        }

        @NotNull
        protected JComponent createEditor() {
            return FormBuilder.createFormBuilder().addLabeledComponent("&Host:", (JComponent)this.hostField).addLabeledComponent("&Port:", (JComponent)this.portField).getPanel();
        }
    }
}

