/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.rpc.CommandProcessorKt;

public final class RejectErrorReporter
implements Consumer<Throwable> {
    private final XDebugSession session;
    private final String description;

    public RejectErrorReporter(@NotNull XDebugSession session) {
        this(session, null);
    }

    public RejectErrorReporter(@NotNull XDebugSession session, @Nullable String description) {
        this.session = session;
        this.description = description;
    }

    public void consume(Throwable error) {
        Promise.logError((Logger)CommandProcessorKt.getLOG(), (Throwable)error);
        if (error != AsyncPromise.OBSOLETE_ERROR) {
            this.session.reportError((this.description == null ? "" : this.description + ": ") + error.getMessage());
        }
    }
}

