/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.Value;

public class ObjectPropertyImpl
extends VariableImpl
implements ObjectProperty {
    public static final byte WRITABLE = 1;
    public static final byte CONFIGURABLE = 2;
    public static final byte ENUMERABLE = 4;
    private final FunctionValue getter;
    private final FunctionValue setter;
    private final int flags;

    public ObjectPropertyImpl(@NotNull String name, @Nullable Value value, @Nullable FunctionValue getter, @Nullable FunctionValue setter, @Nullable ValueModifier valueModifier, int flags) {
        super(name, value, valueModifier);
        this.getter = getter;
        this.setter = setter;
        this.flags = flags;
    }

    @Override
    @Nullable
    public final FunctionValue getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public final FunctionValue getSetter() {
        return this.setter;
    }

    @Override
    public final boolean isWritable() {
        return BitUtil.isSet((int)this.flags, (int)1);
    }

    @Override
    public final boolean isConfigurable() {
        return BitUtil.isSet((int)this.flags, (int)2);
    }

    @Override
    public final boolean isEnumerable() {
        return BitUtil.isSet((int)this.flags, (int)4);
    }
}

