/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueGroupFactory;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueType;

public final class LazyVariablesGroup
extends XValueGroup {
    public static final ValueGroupFactory<ObjectValue> GROUP_FACTORY = new ValueGroupFactory<ObjectValue>(){

        @Override
        public XValueGroup create(@NotNull ObjectValue value, int start, int end, @NotNull VariableContext context) {
            return new LazyVariablesGroup(value, start, end, context);
        }
    };
    private final ObjectValue value;
    private final int startInclusive;
    private final int endInclusive;
    private final VariableContext context;
    private final ValueType componentType;
    private final boolean sparse;

    public LazyVariablesGroup(@NotNull ObjectValue value, int startInclusive, int endInclusive, @NotNull VariableContext context) {
        this(value, startInclusive, endInclusive, context, null, true);
    }

    public LazyVariablesGroup(@NotNull ObjectValue value, int startInclusive, int endInclusive, @NotNull VariableContext context, @Nullable ValueType componentType, boolean sparse) {
        super(String.format("[%,d \u2026 %,d]", startInclusive, endInclusive));
        this.value = value;
        this.startInclusive = startInclusive;
        this.endInclusive = endInclusive;
        this.context = context;
        this.componentType = componentType;
        this.sparse = sparse;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        node.setAlreadySorted(true);
        int bucketThreshold = 100;
        if (!this.sparse && this.endInclusive - this.startInclusive > bucketThreshold) {
            node.addChildren(XValueChildrenList.topGroups(LazyVariablesGroup.computeNotSparseGroups(this.value, this.context, this.startInclusive, this.endInclusive + 1, bucketThreshold)), true);
            return;
        }
        this.value.getIndexedProperties(this.startInclusive, this.endInclusive + 1, bucketThreshold, new VariableView.ObsolescentIndexedVariablesConsumer(node){

            @Override
            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroup.addGroups(LazyVariablesGroup.this.value, GROUP_FACTORY, groupList, LazyVariablesGroup.this.startInclusive, LazyVariablesGroup.this.endInclusive, 100, LazyVariablesGroup.this.context);
                    this.getNode().addChildren(groupList, true);
                } else {
                    LazyVariablesGroup.addRanges(LazyVariablesGroup.this.value, ranges, this.getNode(), LazyVariablesGroup.this.context, true);
                }
            }

            @Override
            public void consumeVariables(@NotNull List<Variable> variables) {
                this.getNode().addChildren(VariablesKt.createVariablesList(variables, LazyVariablesGroup.this.context, null), true);
            }
        }, this.componentType);
    }

    @NotNull
    public static List<XValueGroup> computeNotSparseGroups(@NotNull ObjectValue value, @NotNull VariableContext context, int fromInclusive, int toExclusive, int bucketThreshold) {
        int size = toExclusive - fromInclusive;
        int bucketSize = (int)Math.pow(bucketThreshold, Math.ceil(Math.log(size) / Math.log(bucketThreshold)) - 1.0);
        ArrayList<XValueGroup> groupList = new ArrayList<XValueGroup>((int)Math.ceil(size / bucketSize));
        while (fromInclusive < toExclusive) {
            groupList.add(new LazyVariablesGroup(value, fromInclusive, fromInclusive + (Math.min(bucketSize, toExclusive - fromInclusive) - 1), context, ValueType.NUMBER, false));
            fromInclusive += bucketSize;
        }
        return groupList;
    }

    public static void addRanges(@NotNull ObjectValue value, int[] ranges, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        XValueChildrenList groupList = new XValueChildrenList(ranges.length / 2);
        int n = ranges.length;
        for (int i = 0; i < n; i += 2) {
            groupList.addTopGroup((XValueGroup)new LazyVariablesGroup(value, ranges[i], ranges[i + 1], context));
        }
        node.addChildren(groupList, isLast);
    }

    public static <T> void addGroups(@NotNull T data, @NotNull ValueGroupFactory<T> groupFactory, @NotNull XValueChildrenList groupList, int from, int limit, int bucketSize, @NotNull VariableContext context) {
        int to = Math.min(bucketSize, limit);
        boolean done2 = false;
        do {
            int groupFrom = from;
            int groupTo = to;
            if ((to = (from += bucketSize) + Math.min(bucketSize, limit - from)) - from == 1) {
                ++groupTo;
                done2 = true;
            }
            groupList.addTopGroup(groupFactory.create(data, groupFrom, groupTo, context));
        } while (from < limit && !done2);
    }
}

