/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;

public class CustomPropertiesValuePresentation
extends XValuePresentation {
    private final ObjectValue value;
    private final List<Variable> properties;

    public CustomPropertiesValuePresentation(@NotNull ObjectValue value, @NotNull List<Variable> properties) {
        this.value = value;
        this.properties = properties;
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        renderer.renderComment(VariableViewKt.getObjectValueDescription(this.value));
        renderer.renderSpecialSymbol(" {");
        boolean isFirst = true;
        block7: for (Variable property : this.properties) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(", ");
            }
            renderer.renderValue(property.getName());
            renderer.renderSpecialSymbol(": ");
            Value value = property.getValue();
            assert (value != null);
            switch (value.getType()) {
                case BOOLEAN: 
                case NULL: 
                case UNDEFINED: {
                    renderer.renderKeywordValue(value.getValueString());
                    continue block7;
                }
                case NUMBER: {
                    renderer.renderNumericValue(value.getValueString());
                    continue block7;
                }
                case STRING: {
                    String string = value.getValueString();
                    renderer.renderStringValue(string, "\"\\", 1000);
                    int actualStringLength = value instanceof StringValue ? ((StringValue)value).getLength() : string.length();
                    if (actualStringLength <= 1000) continue block7;
                    renderer.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])new Object[]{actualStringLength}));
                    continue block7;
                }
                case FUNCTION: {
                    renderer.renderComment(VariableViewKt.trimFunctionDescription(value));
                    continue block7;
                }
                case OBJECT: {
                    renderer.renderComment(VariableViewKt.getObjectValueDescription((ObjectValue)value));
                    continue block7;
                }
            }
            renderer.renderValue(value.getValueString());
        }
        renderer.renderSpecialSymbol("}");
    }
}

