/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020)H&J\b\u0010*\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020\fH&J\u0015\u0010,\u001a\u00020-2\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00020-2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u000100R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010#R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00061"}, d2={"Lorg/jetbrains/debugger/BreakpointBase;", "L", "", "Lorg/jetbrains/debugger/Breakpoint;", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;Z)V", "actualLocations", "", "getActualLocations", "()Ljava/util/List;", "getColumn", "()I", "value", "getCondition", "()Ljava/lang/String;", "setCondition", "(Ljava/lang/String;)V", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "getEnabled", "setEnabled", "isResolved", "getLine", "setLine", "(I)V", "getTarget", "()Lorg/jetbrains/debugger/BreakpointTarget;", "flush", "Lorg/jetbrains/concurrency/Promise;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "hashCode", "isVmRegistered", "setActualLocation", "", "(Ljava/lang/Object;)V", "setActualLocations", "", "script-debugger-backend"})
public abstract class BreakpointBase<L>
implements Breakpoint {
    @NotNull
    private final List<L> actualLocations;
    private volatile boolean dirty;
    @Nullable
    private String condition;
    private boolean enabled;
    @NotNull
    private final BreakpointTarget target;
    private int line;
    private final int column;

    @NotNull
    public final List<L> getActualLocations() {
        return this.actualLocations;
    }

    protected final boolean getDirty() {
        return this.dirty;
    }

    protected final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public boolean isResolved() {
        return !this.actualLocations.isEmpty();
    }

    @Override
    @Nullable
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(@Nullable String value) {
        if (Intrinsics.areEqual((Object)this.condition, (Object)value) ^ true) {
            this.condition = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            this.dirty = true;
        }
    }

    public final void setActualLocations(@Nullable List<? extends L> value) {
        this.actualLocations.clear();
        if (!ContainerUtil.isEmpty((Collection)value)) {
            List<? extends L> list = value;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            this.actualLocations.addAll((Collection)list);
        }
    }

    public final void setActualLocation(@Nullable L value) {
        this.actualLocations.clear();
        if (value != null) {
            this.actualLocations.add(value);
        }
    }

    public abstract boolean isVmRegistered();

    public int hashCode() {
        int result = this.getLine();
        result *= 31 + this.getColumn();
        result *= 31 + (this.getEnabled() ? 1 : 0);
        if (this.getCondition() != null) {
            String string = this.getCondition();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            result *= 31 + string.hashCode();
        }
        return result *= 31 + this.getTarget().hashCode();
    }

    @NotNull
    public abstract Promise<?> flush(@NotNull BreakpointManager var1);

    @Override
    @NotNull
    public BreakpointTarget getTarget() {
        return this.target;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public BreakpointBase(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.line = line;
        this.column = column;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLockFreeCopyOnWriteList<L>()");
        this.actualLocations = list;
        this.condition = condition;
        this.enabled = enabled;
    }

    @Override
    public boolean isActualLineCorrect() {
        return Breakpoint.DefaultImpls.isActualLineCorrect(this);
    }
}

