/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.PercentEscaper;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.Strftime;

public class SsiProcessingState {
    protected static final String DEFAULT_CONFIG_ERR_MSG = "[an error occurred while processing this directive]";
    protected static final String DEFAULT_CONFIG_TIME_FMT = "%A, %d-%b-%Y %T %Z";
    protected static final String DEFAULT_CONFIG_SIZE_FMT = "abbrev";
    protected static final Escaper urlEscaper = new PercentEscaper(",:-_.*/!~'()", false);
    protected String configErrorMessage = "[an error occurred while processing this directive]";
    protected String configTimeFmt = "%A, %d-%b-%Y %T %Z";
    protected String configSizeFmt = "abbrev";
    protected final SsiExternalResolver ssiExternalResolver;
    protected final long lastModifiedDate;
    protected Strftime strftime;
    protected final SsiConditionalState conditionalState = new SsiConditionalState();
    private boolean alreadySet;

    public SsiProcessingState(@NotNull SsiExternalResolver ssiExternalResolver, long lastModifiedDate) {
        this.ssiExternalResolver = ssiExternalResolver;
        this.lastModifiedDate = lastModifiedDate;
        this.setConfigTimeFormat(DEFAULT_CONFIG_TIME_FMT, true);
    }

    public void setConfigTimeFormat(String configTimeFmt, boolean fromConstructor) {
        this.configTimeFmt = configTimeFmt;
        this.strftime = new Strftime(configTimeFmt, Locale.US);
        this.setDateVariables(fromConstructor);
    }

    public String getVariableValue(String variableName) {
        return this.getVariableValue(variableName, "none");
    }

    public String getVariableValue(@NotNull String variableName, String encoding) {
        String variableValue = this.ssiExternalResolver.getVariableValue(variableName);
        return variableValue == null ? null : this.encode(variableValue, encoding);
    }

    public String substituteVariables(String val) {
        int charEnd;
        if (val.indexOf(36) < 0 && val.indexOf(38) < 0) {
            return val;
        }
        val = val.replace("&lt;", "<");
        val = val.replace("&gt;", ">");
        val = val.replace("&quot;", "\"");
        val = val.replace("&amp;", "&");
        StringBuilder sb = new StringBuilder(val);
        int charStart = sb.indexOf("&#");
        while (charStart > -1 && (charEnd = sb.indexOf(";", charStart)) > -1) {
            char c = (char)Integer.parseInt(sb.substring(charStart + 2, charEnd));
            sb.delete(charStart, charEnd + 1);
            sb.insert(charStart, c);
            charStart = sb.indexOf("&#");
        }
        int i = 0;
        while (i < sb.length()) {
            String varName;
            String value;
            while (i < sb.length()) {
                if (sb.charAt(i) == '$') {
                    ++i;
                    break;
                }
                ++i;
            }
            if (i == sb.length()) break;
            if (i > 1 && sb.charAt(i - 2) == '\\') {
                sb.deleteCharAt(i - 2);
                --i;
                continue;
            }
            int nameStart = i;
            int start = i - 1;
            char endChar = ' ';
            if (sb.charAt(i) == '{') {
                ++nameStart;
                endChar = '}';
            }
            while (i < sb.length() && sb.charAt(i) != endChar) {
                ++i;
            }
            int end = i;
            int nameEnd = end++;
            if (endChar == '}') {
                // empty if block
            }
            if ((value = this.getVariableValue(varName = sb.substring(nameStart, nameEnd))) == null) {
                value = "";
            }
            sb.replace(start, end, value);
            i = start + value.length();
        }
        return sb.toString();
    }

    protected void setDateVariables(boolean fromConstructor) {
        if (fromConstructor && this.alreadySet) {
            return;
        }
        this.alreadySet = true;
        Date date = new Date();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.ssiExternalResolver.setVariableValue("DATE_GMT", this.formatDate(date, timeZone));
        this.ssiExternalResolver.setVariableValue("DATE_LOCAL", this.formatDate(date, null));
        this.ssiExternalResolver.setVariableValue("LAST_MODIFIED", this.formatDate(new Date(this.lastModifiedDate), null));
    }

    @NotNull
    protected String formatDate(@NotNull Date date, @Nullable TimeZone timeZone) {
        if (timeZone == null) {
            return this.strftime.format(date);
        }
        TimeZone oldTimeZone = this.strftime.getTimeZone();
        this.strftime.setTimeZone(timeZone);
        String retVal = this.strftime.format(date);
        this.strftime.setTimeZone(oldTimeZone);
        return retVal;
    }

    @NotNull
    protected String encode(@NotNull String value, @NotNull String encoding) {
        if (encoding.equalsIgnoreCase("url")) {
            return urlEscaper.escape(value);
        }
        if (encoding.equalsIgnoreCase("none")) {
            return value;
        }
        if (encoding.equalsIgnoreCase("entity")) {
            return HtmlEscapers.htmlEscaper().escape(value);
        }
        throw new IllegalArgumentException("Unknown encoding: " + encoding);
    }

    static class SsiConditionalState {
        boolean branchTaken = false;
        int nestingCount = 0;
        boolean processConditionalCommandsOnly = false;

        SsiConditionalState() {
        }
    }
}

