/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import io.netty.buffer.ByteBufUtf8Writer;
import java.text.DecimalFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiProcessorKt;

final class SsiFsize
implements SsiCommand {
    private static final int ONE_KILOBYTE = 1024;
    private static final int ONE_MEGABYTE = 0x100000;

    SsiFsize() {
    }

    @Override
    public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
        long lastModified = 0L;
        String configErrMsg = state.configErrorMessage;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            String paramValue = paramValues[i];
            String substitutedValue = state.substituteVariables(paramValue);
            if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                boolean virtual = paramName.equalsIgnoreCase("virtual");
                lastModified = state.ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                writer.write(SsiFsize.formatSize(state.ssiExternalResolver.getFileSize(substitutedValue, virtual), state.configSizeFmt));
                continue;
            }
            SsiProcessorKt.getLOG().info("#fsize--Invalid attribute: " + paramName);
            writer.write(configErrMsg);
        }
        return lastModified;
    }

    private static String formatSize(long size, @NotNull String format) {
        if (format.equalsIgnoreCase("bytes")) {
            return new DecimalFormat("#,##0").format(size);
        }
        String result = size == 0L ? "0k" : (size < 1024L ? "1k" : (size < 0x100000L ? Long.toString((size + 512L) / 1024L) + "k" : (size < 0x6300000L ? new DecimalFormat("0.0M").format((double)size / 1048576.0) : Long.toString((size + 541696L) / 0x100000L) + "M")));
        int charsToAdd = 5 - result.length();
        if (charsToAdd < 0) {
            throw new IllegalArgumentException("Num chars can't be negative");
        }
        if (charsToAdd == 0) {
            return result;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < charsToAdd; ++i) {
            buf.append(' ');
        }
        return buf.append(result).toString();
    }
}

