/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManager;

public class BuiltInWebBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(BuiltInWebBrowserUrlProvider.class);

    @NotNull
    public static List<Url> getUrls(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable String currentAuthority) {
        return BuiltInWebBrowserUrlProvider.getUrls(file2, project2, currentAuthority, true);
    }

    @NotNull
    public static List<Url> getUrls(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable String currentAuthority, boolean appendAccessToken) {
        if (currentAuthority != null && !BuiltInWebBrowserUrlProvider.compareAuthority(currentAuthority)) {
            return Collections.emptyList();
        }
        String path = WebServerPathToFileManager.getInstance(project2).getPath(file2);
        if (path == null) {
            return Collections.emptyList();
        }
        int effectiveBuiltInServerPort = BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
        String userToken = null;
        try {
            userToken = BuiltinWebServerAccess.getUserAuthenticationToken();
        }
        catch (IOException e) {
            LOG.warn(String.format("Unable to get User authentication token for launching path '%s'", path), (Throwable)e);
            return Collections.emptyList();
        }
        Url url = Urls.newHttpUrl(currentAuthority == null ? "localhost:" + effectiveBuiltInServerPort : currentAuthority, '/' + userToken + '/' + project2.getName() + '/' + path);
        int defaultPort = BuiltInServerManager.getInstance().getPort();
        if (currentAuthority != null || defaultPort == effectiveBuiltInServerPort) {
            return Collections.singletonList(url);
        }
        return Arrays.asList(url, Urls.newHttpUrl(currentAuthority == null ? "localhost:" + defaultPort : currentAuthority, '/' + userToken + '/' + project2.getName() + '/' + path));
    }

    public static boolean compareAuthority(@Nullable String currentAuthority) {
        if (StringUtil.isEmpty((String)currentAuthority)) {
            return false;
        }
        int portIndex = currentAuthority.indexOf(58);
        if (portIndex < 0) {
            return false;
        }
        String host = currentAuthority.substring(0, portIndex);
        if (!BuiltInWebServerKt.isOwnHostName(host)) {
            return false;
        }
        int port = StringUtil.parseInt((String)currentAuthority.substring(portIndex + 1), (int)-1);
        return port == BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() || port == BuiltInServerManager.getInstance().getPort();
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        if (request.getVirtualFile() instanceof HttpVirtualFile) {
            return true;
        }
        FileViewProvider viewProvider = request.getFile().getViewProvider();
        return viewProvider.isPhysical() && !(request.getVirtualFile() instanceof LightVirtualFile) && this.isMyLanguage(viewProvider.getBaseLanguage());
    }

    protected boolean isMyLanguage(@NotNull Language language) {
        return WebBrowserService.isHtmlOrXmlFile((Language)language);
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file2) throws WebBrowserUrlProvider.BrowserException {
        if (file2 instanceof HttpVirtualFile) {
            return Urls.newFromVirtualFile(file2);
        }
        return (Url)ContainerUtil.getFirstItem(BuiltInWebBrowserUrlProvider.getUrls(file2, request.getProject(), null, request.isAppendAccessToken()));
    }
}

