/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.xml.dom.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.intellij.plugins.relaxNG.xml.dom.impl.DefinitionReference;
import org.jetbrains.annotations.NotNull;

class CreatePatternFix
implements IntentionAction,
LocalQuickFix {
    private final PsiReference myReference;

    public CreatePatternFix(PsiReference reference) {
        this.myReference = reference;
    }

    @NotNull
    public String getText() {
        return "Create Pattern '" + this.myReference.getCanonicalText() + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Create Pattern";
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.doFix();
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.isAvailable();
    }

    private boolean isAvailable() {
        if (!(this.myReference instanceof DefinitionReference) || !this.myReference.getElement().isValid()) {
            return false;
        }
        RngGrammar grammar = ((DefinitionReference)this.myReference).getScope();
        if (grammar == null) {
            return false;
        }
        return grammar.getXmlTag() != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.doFix();
    }

    private void doFix() throws IncorrectOperationException {
        XmlTag[] tags;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myReference.getElement(), XmlTag.class);
        assert (tag != null);
        XmlTag defineTag = tag.createChildTag("define", "http://relaxng.org/ns/structure/1.0", "\n \n", false);
        defineTag.setAttribute("name", this.myReference.getCanonicalText());
        RngGrammar grammar = ((DefinitionReference)this.myReference).getScope();
        if (grammar == null) {
            return;
        }
        XmlTag root = grammar.getXmlTag();
        if (root == null) {
            return;
        }
        for (XmlTag xmlTag : tags = root.getSubTags()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)xmlTag, (PsiElement)tag, (boolean)false)) continue;
            XmlElementFactory ef = XmlElementFactory.getInstance((Project)tag.getProject());
            XmlText text = ef.createDisplayText(" ");
            PsiElement e = root.addAfter((PsiElement)text, (PsiElement)xmlTag);
            root.addAfter((PsiElement)defineTag, e);
            return;
        }
        root.add((PsiElement)defineTag);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static XmlTag getAncestorTag(XmlTag tag, String name, String namespace) {
        if (tag == null) {
            return null;
        }
        if (tag.getLocalName().equals(name) && tag.getNamespace().equals(namespace)) {
            return tag;
        }
        return CreatePatternFix.getAncestorTag(tag.getParentTag(), name, namespace);
    }
}

