/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.relaxNG.references.AddValueCondition;
import org.intellij.plugins.relaxNG.references.AttributeValueCondition;
import org.intellij.plugins.relaxNG.references.AttributeValueFunction;
import org.intellij.plugins.relaxNG.references.ResolvingVisitor;
import org.jetbrains.annotations.NotNull;

public class IdRefProvider
extends PsiReferenceProvider {
    public static final HasIdRefTypeCondition HAS_ID_REF_TYPE = new HasIdRefTypeCondition();
    public static final HasIdTypeCondition HAS_ID_TYPE = new HasIdTypeCondition();

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlAttributeValue value = (XmlAttributeValue)element;
        if (IdRefProvider.hasIdRefType(value)) {
            return new PsiReference[]{new IdReference(value)};
        }
        if (IdRefProvider.hasIdType(value)) {
            return new PsiReference[]{new AttributeValueSelfReference(element)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean hasIdType(XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor = ((XmlAttribute)xmlAttributeValue.getParent()).getDescriptor();
        return descriptor != null && descriptor.hasIdType();
    }

    private static boolean hasIdRefType(XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor = ((XmlAttribute)xmlAttributeValue.getParent()).getDescriptor();
        return descriptor != null && descriptor.hasIdRefType();
    }

    static class HasIdRefTypeCondition
    extends PatternCondition<XmlAttributeValue> {
        public HasIdRefTypeCondition() {
            super("IdRef");
        }

        public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
            return IdRefProvider.hasIdRefType(xmlAttributeValue);
        }
    }

    static class HasIdTypeCondition
    extends PatternCondition<XmlAttributeValue> {
        public HasIdTypeCondition() {
            super("IdType");
        }

        public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
            return IdRefProvider.hasIdType(xmlAttributeValue);
        }
    }

    private static class IdReference
    extends PsiReferenceBase<XmlAttributeValue> {
        private static final Key<XmlAttributeValue> TARGET = Key.create((String)"target");
        private static final Key<Set<XmlAttributeValue>> VARIANTS = Key.create((String)"variants");
        private static final XmlAttributeValuePattern PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute())).with((PatternCondition)HAS_ID_TYPE);
        private final AttributeValueCondition myCondition;

        public IdReference(XmlAttributeValue element) {
            super((PsiElement)element, TextRange.from((int)1, (int)(element.getTextLength() - 2)), true);
            this.myCondition = new AttributeValueCondition(element.getValue());
        }

        public PsiElement resolve() {
            final ProcessingContext context = new ProcessingContext();
            ResolvingVisitor visitor = new ResolvingVisitor((XmlAttributeValuePattern)((XmlAttributeValuePattern)PATTERN.with((PatternCondition)this.myCondition)).save(TARGET), context){

                @Override
                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    if (this.shouldContinue()) {
                        this.visitSubTags(tag);
                    }
                }

                @Override
                protected boolean shouldContinue() {
                    return context.get(TARGET) == null;
                }
            };
            this.process(visitor);
            return (PsiElement)context.get(TARGET);
        }

        private void process(ResolvingVisitor visitor) {
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlDocument.class);
            if (document != null) {
                visitor.execute((PsiElement)document);
            }
        }

        @NotNull
        public Object[] getVariants() {
            ProcessingContext context = new ProcessingContext();
            context.put(VARIANTS, new HashSet());
            ResolvingVisitor visitor = new ResolvingVisitor((XmlAttributeValuePattern)PATTERN.with(AddValueCondition.create(VARIANTS)), context){

                @Override
                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    this.visitSubTags(tag);
                }
            };
            this.process(visitor);
            return AttributeValueFunction.toStrings((Set)context.get(VARIANTS));
        }
    }
}

