/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncInclude;
import org.jetbrains.annotations.NotNull;

public class RelaxIncludeProvider
extends FileIncludeProvider {
    @Override
    @NotNull
    public String getId() {
        return "relax-ng";
    }

    @Override
    public boolean acceptFile(VirtualFile file2) {
        FileType type = file2.getFileType();
        return type == XmlFileType.INSTANCE || type == RncFileType.getInstance();
    }

    @Override
    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        fileTypeSink.consume((Object)XmlFileType.INSTANCE);
        fileTypeSink.consume((Object)RncFileType.getInstance());
    }

    @Override
    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        ArrayList<FileIncludeInfo> infos;
        if (content.getFileType() == XmlFileType.INSTANCE) {
            CharSequence inputDataContentAsText = content.getContentAsText();
            if (CharArrayUtil.indexOf((CharSequence)inputDataContentAsText, (CharSequence)"http://relaxng.org/ns/structure/1.0", (int)0) == -1) {
                return FileIncludeInfo.EMPTY;
            }
            infos = new ArrayList();
            NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)content.getContentAsText()), (IXMLBuilder)new RngBuilderAdapter(infos));
        } else if (content.getFileType() == RncFileType.getInstance()) {
            infos = new ArrayList<FileIncludeInfo>();
            content.getPsiFile().acceptChildren((PsiElementVisitor)new RncElementVisitor(){

                @Override
                public void visitElement(RncElement element) {
                    element.acceptChildren(this);
                }

                @Override
                public void visitInclude(RncInclude include) {
                    String path = include.getFileReference();
                    if (path != null) {
                        infos.add(new FileIncludeInfo(path));
                    }
                }
            });
        } else {
            return FileIncludeInfo.EMPTY;
        }
        return infos.toArray(new FileIncludeInfo[infos.size()]);
    }

    private static class RngBuilderAdapter
    extends NanoXmlUtil.IXMLBuilderAdapter {
        boolean isRNG;
        boolean isInclude;
        private final ArrayList<FileIncludeInfo> myInfos;

        public RngBuilderAdapter(ArrayList<FileIncludeInfo> infos) {
            this.myInfos = infos;
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            boolean isRngTag = "http://relaxng.org/ns/structure/1.0".equals(nsURI);
            if (!this.isRNG) {
                if (!isRngTag) {
                    RngBuilderAdapter.stop();
                } else {
                    this.isRNG = true;
                }
            }
            this.isInclude = isRngTag && "include".equals(name);
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
            if (this.isInclude && "href".equals(key)) {
                this.myInfos.add(new FileIncludeInfo(value));
            }
        }

        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
            this.isInclude = false;
        }
    }
}

