/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RngCompactLanguage;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDocument;
import org.jetbrains.annotations.NotNull;

public class RncFileImpl
extends PsiFileBase
implements RncFile,
XmlFile {
    private static final TokenSet DECLS = TokenSet.create((IElementType[])new IElementType[]{RncElementTypes.NS_DECL, RncElementTypes.DATATYPES_DECL});

    public RncFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, RngCompactLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        return RncFileType.getInstance();
    }

    @NotNull
    public XmlDocument getDocument() {
        XmlDocument document = this.findChildByClass(XmlDocument.class);
        assert (document != null);
        return document;
    }

    public XmlTag getRootTag() {
        return this.getDocument().getRootTag();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        ASTNode[] nodes;
        ASTNode docNode = this.getDocument().getNode();
        assert (docNode != null);
        for (ASTNode node : nodes = docNode.getChildren(DECLS)) {
            if (processor2.execute(node.getPsi(), substitutor)) continue;
            return false;
        }
        RncGrammar grammar = this.getGrammar();
        if (grammar != null) {
            return grammar.processDeclarations(processor2, substitutor, lastParent, place);
        }
        return true;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.getDocument().add(element);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.getDocument().addAfter(element, anchor);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.getDocument().addBefore(element, anchor);
    }

    public boolean processElements(PsiElementProcessor processor2, PsiElement place) {
        return false;
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        return ProjectScope.getAllScope((Project)this.getProject());
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName();
    }

    @Override
    public RncDecl[] getDeclarations() {
        return ((RncDocument)this.getDocument()).findChildrenByClass(RncDecl.class);
    }

    @Override
    public RncGrammar getGrammar() {
        XmlDocument document = this.getDocument();
        return ((RncDocument)document).getGrammar();
    }
}

