/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.jetbrains.annotations.NotNull;

public abstract class RncElementImpl
extends ASTWrapperPsiElement
implements RncElement,
CommonElement<RncElement> {
    private static final TokenSet GRAMMAR_CONTENT = TokenSet.create((IElementType[])new IElementType[]{RncElementTypes.START, RncElementTypes.DEFINE, RncElementTypes.DIV, RncElementTypes.GRAMMAR_PATTERN, RncElementTypes.PATTERN, RncElementTypes.INCLUDE});

    public RncElementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public String toString() {
        return this.getNode().getElementType().toString();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.getNode().getTreeParent().removeChild(this.getNode());
    }

    @Override
    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        ASTNode astNode = psiElement.getNode();
        assert (astNode != null);
        this.getNode().addChild(astNode);
        PsiElement r = this.getNode().getLastChildNode().getPsi();
        assert (r.getClass() == psiElement.getClass());
        return r;
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement psiElement, PsiElement anchor) throws IncorrectOperationException {
        ASTNode child = psiElement.getNode();
        assert (child != null);
        ASTNode anchorNode = anchor.getNode();
        assert (anchorNode != null);
        this.getNode().addChild(child, anchorNode);
        PsiElement r = anchorNode.getTreePrev().getPsi();
        assert (r.getClass() == psiElement.getClass());
        return r;
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        ASTNode astNode = anchor.getNode();
        assert (astNode != null);
        ASTNode node = astNode.getTreeNext();
        if (node == null) {
            return this.add(element);
        }
        return this.addBefore(element, node.getPsi());
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof RncElementVisitor) {
            this.accept((RncElementVisitor)visitor);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        ASTNode astNode = this.getNode();
        ASTNode[] children2 = astNode.getChildren(GRAMMAR_CONTENT);
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (ASTNode element : children2) {
            if (processor2.execute(element.getPsi(), substitutor)) continue;
            return false;
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, null);
        return true;
    }

    public abstract void accept(@NotNull RncElementVisitor var1);

    @Override
    public void accept(CommonElement.Visitor visitor) {
        visitor.visitElement(this);
    }

    @Override
    public void acceptChildren(CommonElement.Visitor visitor) {
        PsiElement[] elements = this.getChildren();
        for (int i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            if (!(element instanceof CommonElement)) continue;
            ((CommonElement)element).accept(visitor);
        }
    }

    @Override
    public RncElement getPsiElement() {
        return this;
    }
}

