/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.NotNullFunction;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.RngCompactLanguage;
import org.intellij.plugins.relaxNG.compact.lexer.CompactSyntaxLexerAdapter;
import org.intellij.plugins.relaxNG.compact.parser.RncParser;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncFileImpl;
import org.jetbrains.annotations.NotNull;

public class RncParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType((Language)RngCompactLanguage.INSTANCE);
    private static final TokenSet myCommentTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{RncTokenTypes.COMMENTS, RncTokenTypes.DOC_TOKENS});

    @NotNull
    public Lexer createLexer(Project project2) {
        return new CompactSyntaxLexerAdapter();
    }

    public PsiParser createParser(Project project2) {
        return new RncParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return myCommentTypes;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.LITERAL});
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof NotNullFunction) {
            return (PsiElement)((NotNullFunction)type).fun((Object)node);
        }
        return new MyRncElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RncFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static class MyRncElement
    extends RncElementImpl {
        public MyRncElement(ASTNode node) {
            super(node);
        }

        @Override
        public void accept(@NotNull RncElementVisitor visitor) {
            visitor.visitElement(this);
        }
    }
}

