/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;

class SimplifyQuantifierAction
implements IntentionAction {
    private final RegExpQuantifier myQuantifier;
    private final String myReplacement;

    public SimplifyQuantifierAction(RegExpQuantifier quantifier, String s) {
        this.myQuantifier = quantifier;
        this.myReplacement = s;
    }

    @NotNull
    public String getText() {
        return this.myReplacement == null ? "Simplify" : "Replace with '" + this.myReplacement + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Simplify Quantifier";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myQuantifier.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (this.myReplacement == null) {
            this.myQuantifier.delete();
        } else {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
            PsiFile f = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)("a" + this.myReplacement + this.myQuantifier.getType().getToken()));
            RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
            assert (pattern != null);
            RegExpClosure closure = (RegExpClosure)pattern.getBranches()[0].getAtoms()[0];
            this.myQuantifier.replace(closure.getQuantifier());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

