/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.validation.RemoveRedundantEscapeAction;
import org.intellij.lang.regexp.validation.SimplifyQuantifierAction;
import org.jetbrains.annotations.NotNull;

public final class RegExpAnnotator
extends RegExpElementVisitor
implements Annotator {
    private static final Set<String> POSIX_CHARACTER_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"alnum", "alpha", "ascii", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "word", "xdigit"});
    private static final String ILLEGAL_CHARACTER_RANGE_TO_FROM = "Illegal character range (to < from)";
    private AnnotationHolder myHolder;
    private final RegExpLanguageHosts myLanguageHosts = RegExpLanguageHosts.getInstance();

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        assert (this.myHolder == null) : "unsupported concurrent annotator invocation";
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitRegExpCharRange(RegExpCharRange range) {
        RegExpCharRange.Endpoint from = range.getFrom();
        RegExpCharRange.Endpoint to = range.getTo();
        boolean a = from instanceof RegExpChar;
        boolean b = to instanceof RegExpChar;
        if (a && b) {
            Character t = ((RegExpChar)to).getValue();
            Character f = ((RegExpChar)from).getValue();
            if (t != null && f != null) {
                if (t.charValue() < f.charValue()) {
                    if (this.handleSurrogates(range, f, t)) {
                        return;
                    }
                    this.myHolder.createErrorAnnotation((PsiElement)range, ILLEGAL_CHARACTER_RANGE_TO_FROM);
                } else if (t == f) {
                    this.myHolder.createWarningAnnotation((PsiElement)range, "Redundant character range");
                }
            }
        } else if (a != b) {
            this.myHolder.createErrorAnnotation((PsiElement)range, "Character class (e.g. '\\\\w') may not be used inside character range");
        } else if (from.getText().equals(to.getText())) {
            this.myHolder.createWarningAnnotation((PsiElement)range, "Redundant character range");
        }
    }

    private boolean handleSurrogates(RegExpCharRange range, Character f, Character t) {
        PsiElement prevSibling = range.getPrevSibling();
        PsiElement nextSibling = range.getNextSibling();
        if (prevSibling instanceof RegExpChar && nextSibling instanceof RegExpChar) {
            Character prevSiblingValue = ((RegExpChar)prevSibling).getValue();
            Character nextSiblingValue = ((RegExpChar)nextSibling).getValue();
            if (prevSiblingValue != null && nextSiblingValue != null && Character.isSurrogatePair(prevSiblingValue.charValue(), f.charValue()) && Character.isSurrogatePair(t.charValue(), nextSiblingValue.charValue())) {
                if (Character.toCodePoint(prevSiblingValue.charValue(), f.charValue()) > Character.toCodePoint(t.charValue(), nextSiblingValue.charValue())) {
                    TextRange prevSiblingRange = prevSibling.getTextRange();
                    TextRange nextSiblingRange = nextSibling.getTextRange();
                    TextRange errorRange = new TextRange(prevSiblingRange.getStartOffset(), nextSiblingRange.getEndOffset());
                    this.myHolder.createErrorAnnotation(errorRange, ILLEGAL_CHARACTER_RANGE_TO_FROM);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitRegExpClass(RegExpClass regExpClass) {
        HashSet<Character> seen = new HashSet<Character>();
        for (RegExpClassElement element : regExpClass.getElements()) {
            RegExpChar regExpChar;
            Character value;
            if (!(element instanceof RegExpChar) || (value = (regExpChar = (RegExpChar)element).getValue()) == null || seen.add(value)) continue;
            this.myHolder.createWarningAnnotation((PsiElement)regExpChar, "Duplicate character '" + regExpChar.getText() + "' in character class");
        }
    }

    @Override
    public void visitRegExpChar(RegExpChar ch) {
        Character value = ch.getValue();
        if (value == null) {
            switch (ch.getType()) {
                case CHAR: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal/unsupported escape sequence");
                    break;
                }
                case HEX: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal hexadecimal escape sequence");
                    break;
                }
                case OCT: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal octal escape sequence");
                    break;
                }
                case UNICODE: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal unicode escape sequence");
                    break;
                }
            }
        } else {
            ASTNode astNode;
            String text = ch.getUnescapedText();
            if (text.startsWith("\\") && this.myLanguageHosts.isRedundantEscape(ch, text) && (astNode = ch.getNode().getFirstChildNode()) != null && astNode.getElementType() == RegExpTT.REDUNDANT_ESCAPE) {
                Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)ch, "Redundant character escape");
                RegExpAnnotator.registerFix(a, new RemoveRedundantEscapeAction(ch));
            }
            if (ch.getType() == RegExpChar.Type.HEX && text.charAt(text.length() - 1) == '}' && !this.myLanguageHosts.supportsExtendedHexCharacter(ch)) {
                this.myHolder.createErrorAnnotation((PsiElement)ch, "This hex character syntax is not supported");
            }
        }
    }

    @Override
    public void visitRegExpProperty(RegExpProperty property) {
        Annotation a;
        ASTNode category = property.getCategoryNode();
        if (category == null) {
            return;
        }
        if (!this.myLanguageHosts.isValidCategory(category.getPsi(), category.getText()) && (a = this.myHolder.createErrorAnnotation(category, "Unknown character category")) != null) {
            a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @Override
    public void visitRegExpBackref(RegExpBackref backref) {
        RegExpGroup group = backref.resolve();
        if (group == null) {
            Annotation a = this.myHolder.createErrorAnnotation((PsiElement)backref, "Unresolved back reference");
            if (a != null) {
                a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)backref, (boolean)true)) {
            this.myHolder.createWarningAnnotation((PsiElement)backref, "Back reference is nested into the capturing group it refers to");
        }
    }

    @Override
    public void visitRegExpGroup(RegExpGroup group) {
        RegExpPattern pattern = group.getPattern();
        if (pattern != null) {
            RegExpAtom[] atoms;
            RegExpBranch[] branches = pattern.getBranches();
            if (RegExpAnnotator.isEmpty(branches)) {
                this.myHolder.createWarningAnnotation((PsiElement)group, "Empty group");
            } else if (branches.length == 1 && (atoms = branches[0].getAtoms()).length == 1 && atoms[0] instanceof RegExpGroup && group.isSimple()) {
                RegExpGroup innerGroup = (RegExpGroup)atoms[0];
                if (group.isCapturing() == innerGroup.isCapturing()) {
                    this.myHolder.createWarningAnnotation((PsiElement)group, "Redundant group nesting");
                }
            }
        }
        if ((group.isPythonNamedGroup() || group.isRubyNamedGroup()) && !this.myLanguageHosts.supportsNamedGroupSyntax(group)) {
            this.myHolder.createErrorAnnotation((PsiElement)group, "This named group syntax is not supported");
        }
    }

    @Override
    public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
        if (!this.myLanguageHosts.supportsNamedGroupRefSyntax(groupRef)) {
            this.myHolder.createErrorAnnotation((PsiElement)groupRef, "This named group reference syntax is not supported");
            return;
        }
        if (groupRef.getGroupName() == null) {
            return;
        }
        RegExpGroup group = groupRef.resolve();
        if (group == null) {
            Annotation a = this.myHolder.createErrorAnnotation((PsiElement)groupRef, "Unresolved named group reference");
            if (a != null) {
                a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)groupRef, (boolean)true)) {
            this.myHolder.createWarningAnnotation((PsiElement)groupRef, "Group reference is nested into the named group it refers to");
        }
    }

    public void visitComment(PsiComment comment) {
        if (comment.getText().startsWith("(?#") && !this.myLanguageHosts.supportsPerl5EmbeddedComments(comment)) {
            this.myHolder.createErrorAnnotation((PsiElement)comment, "Embedded comments are not supported");
        }
    }

    @Override
    public void visitRegExpPyCondRef(RegExpPyCondRef condRef) {
        if (!this.myLanguageHosts.supportsPythonConditionalRefs(condRef)) {
            this.myHolder.createErrorAnnotation((PsiElement)condRef, "Conditional references are not supported");
        }
    }

    private static boolean isEmpty(RegExpBranch[] branches) {
        for (RegExpBranch branch : branches) {
            if (branch.getAtoms().length <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
        RegExpQuantifier.Count count = quantifier.getCount();
        if (!(count instanceof RegExpQuantifier.SimpleCount)) {
            String min = count.getMin();
            String max = count.getMax();
            if (max.equals(min)) {
                if ("1".equals(max)) {
                    Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Single repetition");
                    RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, null));
                } else {
                    ASTNode node = quantifier.getNode();
                    if (node.findChildByType(RegExpTT.COMMA) != null) {
                        Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Fixed repetition range");
                        RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "{" + max + "}"));
                    }
                }
            } else if ("0".equals(min) && "1".equals(max)) {
                Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Repetition range replaceable by '?'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "?"));
            } else if ("0".equals(min) && max.isEmpty()) {
                Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Repetition range replaceable by '*'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "*"));
            } else if ("1".equals(min) && max.isEmpty()) {
                Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Repetition range replaceable by '+'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "+"));
            } else if (!min.isEmpty() && !max.isEmpty()) {
                try {
                    BigInteger minInt = new BigInteger(min);
                    BigInteger maxInt = new BigInteger(max);
                    if (maxInt.compareTo(minInt) < 0) {
                        this.myHolder.createErrorAnnotation((PsiElement)quantifier, "Illegal repetition range");
                    }
                }
                catch (NumberFormatException ex) {
                    this.myHolder.createErrorAnnotation((PsiElement)quantifier, "Illegal repetition value");
                }
            }
        }
        if (quantifier.getType() == RegExpQuantifier.Type.POSSESSIVE && !this.myLanguageHosts.supportsPossessiveQuantifiers(quantifier)) {
            this.myHolder.createErrorAnnotation((PsiElement)quantifier, "Nested quantifier in regexp");
        }
    }

    @Override
    public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
        Annotation annotation;
        String className = posixBracketExpression.getClassName();
        if (!POSIX_CHARACTER_CLASSES.contains(className) && (annotation = this.myHolder.createErrorAnnotation((PsiElement)posixBracketExpression, "Unknown POSIX character class")) != null) {
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    private static void registerFix(Annotation a, IntentionAction action) {
        if (a != null) {
            a.registerFix(action);
        }
    }
}

