/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpQuantifierImpl
extends RegExpElementImpl
implements RegExpQuantifier {
    public RegExpQuantifierImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpQuantifier(this);
    }

    @Override
    @NotNull
    public RegExpAtom getAtom() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpElementTypes.ATOMS);
        assert (nodes.length > 0);
        return (RegExpAtom)nodes[0].getPsi();
    }

    @Override
    @NotNull
    public RegExpQuantifier.Count getCount() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        assert (nodes.length > 0);
        IElementType type = nodes[0].getElementType();
        if (type == RegExpTT.QUEST) {
            return RegExpQuantifier.SimpleCount.ONE_OR_ZERO;
        }
        if (type == RegExpTT.STAR) {
            return RegExpQuantifier.SimpleCount.ZERO_OR_MORE;
        }
        if (type == RegExpTT.PLUS) {
            return RegExpQuantifier.SimpleCount.ONE_OR_MORE;
        }
        if (type == RegExpTT.LBRACE) {
            ASTNode[] numbers = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{RegExpTT.NUMBER}));
            if (numbers.length >= 1) {
                String min = numbers[0].getText();
                String max = numbers.length == 2 ? numbers[1].getText() : (this.getNode().findChildByType(RegExpTT.COMMA) != null ? "" : min);
                return new RepeatedCount(min, max);
            }
            return new RepeatedCount("", "");
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    public RegExpQuantifier.Type getType() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        if (nodes.length > 1) {
            IElementType type = nodes[1].getElementType();
            if (type == RegExpTT.QUEST) {
                return RegExpQuantifier.Type.RELUCTANT;
            }
            if (type == RegExpTT.PLUS) {
                return RegExpQuantifier.Type.POSSESSIVE;
            }
        }
        return RegExpQuantifier.Type.GREEDY;
    }

    private static class RepeatedCount
    implements RegExpQuantifier.Count {
        private final String myMin;
        private final String myMax;

        public RepeatedCount(@NotNull String min, @NotNull String max) {
            this.myMin = min;
            this.myMax = max;
        }

        @Override
        @NotNull
        public String getMin() {
            return this.myMin;
        }

        @Override
        @NotNull
        public String getMax() {
            return this.myMax;
        }
    }
}

