/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpParser
implements PsiParser {
    private final EnumSet<RegExpCapability> myCapabilities;

    public RegExpParser() {
        this.myCapabilities = EnumSet.noneOf(RegExpCapability.class);
    }

    public RegExpParser(EnumSet<RegExpCapability> capabilities) {
        this.myCapabilities = capabilities;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        this.parsePattern(builder);
        while (!builder.eof()) {
            RegExpParser.patternExpected(builder);
            builder.advanceLexer();
        }
        rootMarker.done(root);
        return builder.getTreeBuilt();
    }

    private boolean parsePattern(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseBranch(builder)) {
            marker.drop();
            return false;
        }
        while (builder.getTokenType() == RegExpTT.UNION) {
            builder.advanceLexer();
            if (this.parseBranch(builder)) continue;
            RegExpParser.patternExpected(builder);
            break;
        }
        marker.done(RegExpElementTypes.PATTERN);
        return true;
    }

    private boolean parseBranch(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseAtom(builder)) {
            IElementType token = builder.getTokenType();
            if (token == RegExpTT.GROUP_END || token == RegExpTT.UNION || token == null) {
                marker.done(RegExpElementTypes.BRANCH);
                return true;
            }
            marker.drop();
            return false;
        }
        while (this.parseAtom(builder)) {
        }
        marker.done(RegExpElementTypes.BRANCH);
        return true;
    }

    private boolean parseAtom(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseGroup(builder);
        if (marker == null) {
            return false;
        }
        marker = marker.precede();
        if (this.parseQuantifier(builder)) {
            marker.done(RegExpElementTypes.CLOSURE);
        } else {
            marker.drop();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseQuantifier(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == RegExpTT.LBRACE) {
            builder.advanceLexer();
            boolean minOmitted = false;
            if (builder.getTokenType() == RegExpTT.COMMA && this.myCapabilities.contains((Object)RegExpCapability.OMIT_NUMBERS_IN_QUANTIFIERS)) {
                minOmitted = true;
                builder.advanceLexer();
            } else {
                if (builder.getTokenType() != RegExpTT.NUMBER && this.myCapabilities.contains((Object)RegExpCapability.DANGLING_METACHARACTERS)) {
                    marker.done(RegExpTT.CHARACTER);
                    return true;
                }
                RegExpParser.checkMatches(builder, RegExpTT.NUMBER, "Number expected");
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (!minOmitted) {
                RegExpParser.checkMatches(builder, RegExpTT.COMMA, "',' expected");
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (builder.getTokenType() == RegExpTT.NUMBER) {
                builder.advanceLexer();
                RegExpParser.checkMatches(builder, RegExpTT.RBRACE, "'}' expected");
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            builder.error("'}' or number expected");
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        if (RegExpTT.QUANTIFIERS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            RegExpParser.parseQuantifierType(builder);
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        marker.drop();
        return false;
    }

    private static void parseQuantifierType(PsiBuilder builder) {
        if (builder.getTokenType() == RegExpTT.PLUS) {
            builder.advanceLexer();
        } else if (builder.getTokenType() == RegExpTT.QUEST) {
            builder.advanceLexer();
        } else if (RegExpTT.QUANTIFIERS.contains(builder.getTokenType())) {
            builder.error("Dangling metacharacter");
        }
    }

    private PsiBuilder.Marker parseClass(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CARET) {
            builder.advanceLexer();
        }
        if (this.parseClassIntersection(builder)) {
            while (RegExpTT.CHARACTERS2.contains(builder.getTokenType()) || builder.getTokenType() == RegExpTT.CLASS_BEGIN || builder.getTokenType() == RegExpTT.PROPERTY || builder.getTokenType() == RegExpTT.BRACKET_EXPRESSION_BEGIN) {
                this.parseClassIntersection(builder);
            }
        }
        RegExpParser.checkMatches(builder, RegExpTT.CLASS_END, "Unclosed character class");
        marker.done(RegExpElementTypes.CLASS);
        return marker;
    }

    private boolean parseClassIntersection(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseClassdef(builder, false)) {
            marker.drop();
            return false;
        }
        while (RegExpTT.ANDAND == builder.getTokenType()) {
            builder.advanceLexer();
            this.parseClassdef(builder, true);
            marker.done(RegExpElementTypes.INTERSECTION);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean parseClassdef(PsiBuilder builder, boolean mayBeEmpty) {
        IElementType token = builder.getTokenType();
        if (token == RegExpTT.CLASS_BEGIN) {
            this.parseClass(builder);
        } else if (token == RegExpTT.BRACKET_EXPRESSION_BEGIN) {
            RegExpParser.parseBracketExpression(builder);
        } else if (RegExpTT.CHARACTERS2.contains(token)) {
            this.parseSimpleClassdef(builder);
        } else if (token == RegExpTT.PROPERTY) {
            RegExpParser.parseProperty(builder);
        } else {
            return mayBeEmpty;
        }
        return true;
    }

    private static void parseBracketExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.NAME, "POSIX character class name expected");
        RegExpParser.checkMatches(builder, RegExpTT.BRACKET_EXPRESSION_END, "Unclosed POSIX bracket expression");
        marker.done(RegExpElementTypes.POSIX_BRACKET_EXPRESSION);
    }

    private void parseSimpleClassdef(PsiBuilder builder) {
        assert (RegExpTT.CHARACTERS2.contains(builder.getTokenType()));
        PsiBuilder.Marker marker = builder.mark();
        RegExpParser.makeChar(builder);
        IElementType t = builder.getTokenType();
        if (t == RegExpTT.MINUS) {
            PsiBuilder.Marker m = builder.mark();
            builder.advanceLexer();
            t = builder.getTokenType();
            if (RegExpTT.CHARACTERS2.contains(t)) {
                m.drop();
                RegExpParser.makeChar(builder);
                marker.done(RegExpElementTypes.CHAR_RANGE);
            } else {
                marker.drop();
                m.done(t == RegExpTT.CHAR_CLASS ? RegExpElementTypes.SIMPLE_CLASS : RegExpElementTypes.CHAR);
                if (t == RegExpTT.CLASS_END) {
                    return;
                }
                if (t == RegExpTT.CLASS_BEGIN && this.parseClassdef(builder, false)) {
                    return;
                }
                builder.error("Illegal character range");
            }
        } else {
            marker.drop();
        }
    }

    private static void makeChar(PsiBuilder builder) {
        IElementType t = builder.getTokenType();
        PsiBuilder.Marker m = builder.mark();
        builder.advanceLexer();
        m.done(t == RegExpTT.CHAR_CLASS ? RegExpElementTypes.SIMPLE_CLASS : RegExpElementTypes.CHAR);
    }

    @Nullable
    private PsiBuilder.Marker parseGroup(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        PsiBuilder.Marker marker = builder.mark();
        if (RegExpTT.GROUPS.contains(type)) {
            builder.advanceLexer();
            if (!this.parsePattern(builder)) {
                RegExpParser.patternExpected(builder);
            } else {
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group");
            }
            marker.done(RegExpElementTypes.GROUP);
        } else if (type == RegExpTT.SET_OPTIONS) {
            builder.advanceLexer();
            PsiBuilder.Marker o = builder.mark();
            if (builder.getTokenType() == RegExpTT.OPTIONS_ON) {
                builder.advanceLexer();
            }
            if (builder.getTokenType() == RegExpTT.OPTIONS_OFF) {
                builder.advanceLexer();
            }
            o.done(RegExpElementTypes.OPTIONS);
            if (builder.getTokenType() == RegExpTT.COLON) {
                builder.advanceLexer();
                if (!this.parsePattern(builder)) {
                    RegExpParser.patternExpected(builder);
                } else {
                    RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group");
                }
                marker.done(RegExpElementTypes.GROUP);
            } else {
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed options group");
                marker.done(RegExpElementTypes.SET_OPTIONS);
            }
        } else if (type == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
            builder.error("Illegal/unsupported escape sequence");
            builder.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        } else if (RegExpTT.CHARACTERS.contains(type)) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        } else if (RegExpTT.BOUNDARIES.contains(type)) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BOUNDARY);
        } else if (type == RegExpTT.BACKREF) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BACKREF);
        } else if (type == RegExpTT.PYTHON_NAMED_GROUP || type == RegExpTT.RUBY_NAMED_GROUP || type == RegExpTT.RUBY_QUOTED_NAMED_GROUP) {
            builder.advanceLexer();
            RegExpParser.checkMatches(builder, RegExpTT.NAME, "Group name expected");
            RegExpParser.checkMatches(builder, type == RegExpTT.RUBY_QUOTED_NAMED_GROUP ? RegExpTT.QUOTE : RegExpTT.GT, "Unclosed group name");
            if (!this.parsePattern(builder)) {
                RegExpParser.patternExpected(builder);
            } else {
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group");
            }
            marker.done(RegExpElementTypes.GROUP);
        } else if (type == RegExpTT.PYTHON_NAMED_GROUP_REF) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.GROUP_END);
        } else if (type == RegExpTT.RUBY_NAMED_GROUP_REF) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.GT);
        } else if (type == RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.QUOTE);
        } else if (type == RegExpTT.PYTHON_COND_REF) {
            builder.advanceLexer();
            if (builder.getTokenType() == RegExpTT.NAME || builder.getTokenType() == RegExpTT.NUMBER) {
                builder.advanceLexer();
            } else {
                builder.error("Group name or number expected");
            }
            RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group reference");
            if (!this.parseBranch(builder)) {
                RegExpParser.patternExpected(builder);
            } else {
                if (builder.getTokenType() == RegExpTT.UNION) {
                    builder.advanceLexer();
                    if (!this.parseBranch(builder)) {
                        RegExpParser.patternExpected(builder);
                    }
                }
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, "Unclosed group");
            }
            marker.done(RegExpElementTypes.PY_COND_REF);
        } else if (type == RegExpTT.PROPERTY) {
            RegExpParser.parseProperty(builder);
            marker.done(RegExpElementTypes.PROPERTY);
        } else if (RegExpTT.SIMPLE_CLASSES.contains(type)) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.SIMPLE_CLASS);
        } else {
            if (type == RegExpTT.CLASS_BEGIN) {
                marker.drop();
                return this.parseClass(builder);
            }
            if (type == RegExpTT.LBRACE && this.myCapabilities.contains((Object)RegExpCapability.DANGLING_METACHARACTERS)) {
                builder.advanceLexer();
                marker.done(RegExpElementTypes.CHAR);
            } else {
                marker.drop();
                return null;
            }
        }
        return marker;
    }

    private static void parseNamedGroupRef(PsiBuilder builder, PsiBuilder.Marker marker, IElementType type) {
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.NAME, "Group name expected");
        RegExpParser.checkMatches(builder, type, "Unclosed group reference");
        marker.done(RegExpElementTypes.NAMED_GROUP_REF);
    }

    private static void parseProperty(PsiBuilder builder) {
        RegExpParser.checkMatches(builder, RegExpTT.PROPERTY, "'\\p' expected");
        if (builder.getTokenType() == RegExpTT.CATEGORY_SHORT_HAND) {
            builder.advanceLexer();
            return;
        }
        RegExpParser.checkMatches(builder, RegExpTT.LBRACE, "Character category expected");
        if (builder.getTokenType() == RegExpTT.NAME) {
            builder.advanceLexer();
        } else if (builder.getTokenType() == RegExpTT.RBRACE) {
            builder.error("Empty character family");
        } else {
            builder.error("Character family name expected");
            builder.advanceLexer();
        }
        RegExpParser.checkMatches(builder, RegExpTT.RBRACE, "Unclosed character family");
    }

    private static void patternExpected(PsiBuilder builder) {
        IElementType token = builder.getTokenType();
        if (token == RegExpTT.GROUP_END) {
            builder.error("Unmatched closing ')'");
        } else if (RegExpTT.QUANTIFIERS.contains(token)) {
            builder.error("Dangling metacharacter");
        } else {
            builder.error("Pattern expected");
        }
    }

    protected static void checkMatches(PsiBuilder builder, IElementType token, String message) {
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
        } else {
            builder.error(message);
        }
    }
}

