/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpLanguageHosts
extends ClassExtension<RegExpLanguageHost> {
    private static final RegExpLanguageHosts INSTANCE = new RegExpLanguageHosts();
    private final DefaultRegExpPropertiesProvider myDefaultProvider = DefaultRegExpPropertiesProvider.getInstance();
    private static RegExpLanguageHost myHost;

    public static RegExpLanguageHosts getInstance() {
        return INSTANCE;
    }

    private RegExpLanguageHosts() {
        super("com.intellij.regExpLanguageHost");
    }

    public static void setRegExpHost(@Nullable RegExpLanguageHost host) {
        myHost = host;
    }

    @Nullable
    private static RegExpLanguageHost findRegExpHost(@Nullable PsiElement element) {
        if (ApplicationManager.getApplication().isUnitTestMode() && myHost != null) {
            return myHost;
        }
        if (element == null) {
            return null;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        if (host instanceof RegExpLanguageHost) {
            return (RegExpLanguageHost)host;
        }
        if (host != null) {
            return (RegExpLanguageHost)INSTANCE.forClass(host.getClass());
        }
        return null;
    }

    public boolean isRedundantEscape(@NotNull RegExpChar ch, @NotNull String text) {
        if (text.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ch);
        if (host != null) {
            char c = text.charAt(1);
            boolean needsEscaping = host.characterNeedsEscaping(c);
            return !needsEscaping;
        }
        return !"\\]".equals(text) && !"\\}".equals(text);
    }

    public boolean supportsExtendedHexCharacter(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        try {
            return host != null && host.supportsExtendedHexCharacter(regExpChar);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public boolean supportsNamedGroupSyntax(@Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host != null && host.supportsNamedGroupSyntax(group);
    }

    public boolean supportsNamedGroupRefSyntax(@Nullable RegExpNamedGroupRef ref) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ref);
        try {
            return host != null && host.supportsNamedGroupRefSyntax(ref);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public boolean supportsPerl5EmbeddedComments(@Nullable PsiComment comment) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost((PsiElement)comment);
        return host != null && host.supportsPerl5EmbeddedComments();
    }

    public boolean supportsPythonConditionalRefs(@Nullable RegExpPyCondRef condRef) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(condRef);
        return host != null && host.supportsPythonConditionalRefs();
    }

    public boolean supportsPossessiveQuantifiers(@Nullable RegExpQuantifier quantifier) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(quantifier);
        return host == null || host.supportsPossessiveQuantifiers();
    }

    public boolean isValidCategory(@NotNull PsiElement element, @NotNull String category) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.isValidCategory(category) : this.myDefaultProvider.isValidCategory(category);
    }

    @NotNull
    public String[][] getAllKnownProperties(@NotNull PsiElement element) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.getAllKnownProperties() : this.myDefaultProvider.getAllKnownProperties();
    }

    @Nullable
    String getPropertyDescription(@NotNull PsiElement element, @Nullable String name) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.getPropertyDescription(name) : this.myDefaultProvider.getPropertyDescription(name);
    }

    @NotNull
    String[][] getKnownCharacterClasses(@NotNull PsiElement element) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.getKnownCharacterClasses() : this.myDefaultProvider.getKnownCharacterClasses();
    }

    String[][] getPosixCharacterClasses(@NotNull PsiElement element) {
        return this.myDefaultProvider.getPosixCharacterClasses();
    }
}

