/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;

public class RegExpHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    static final TextAttributesKey META;
    static final TextAttributesKey INVALID_CHARACTER_ESCAPE;
    static final TextAttributesKey BAD_CHARACTER;
    static final TextAttributesKey REDUNDANT_ESCAPE;
    static final TextAttributesKey PARENTHS;
    static final TextAttributesKey BRACES;
    static final TextAttributesKey BRACKETS;
    static final TextAttributesKey COMMA;
    static final TextAttributesKey ESC_CHARACTER;
    static final TextAttributesKey CHAR_CLASS;
    static final TextAttributesKey QUOTE_CHARACTER;
    static final TextAttributesKey COMMENT;
    private final Project myProject;
    private final ParserDefinition myParserDefinition;

    public RegExpHighlighter(Project project2, ParserDefinition parserDefinition) {
        this.myProject = project2;
        this.myParserDefinition = parserDefinition;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return this.myParserDefinition.createLexer(this.myProject);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        return RegExpHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
    }

    static {
        META = TextAttributesKey.createTextAttributesKey((String)"REGEXP.META", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        INVALID_CHARACTER_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"REGEXP.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        REDUNDANT_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"REGEXP.REDUNDANT_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        PARENTHS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        BRACES = TextAttributesKey.createTextAttributesKey((String)"REGEXP.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        BRACKETS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        COMMA = TextAttributesKey.createTextAttributesKey((String)"REGEXP.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        ESC_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.ESC_CHARACTER", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        CHAR_CLASS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.CHAR_CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        QUOTE_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.QUOTE_CHARACTER", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        COMMENT = TextAttributesKey.createTextAttributesKey((String)"REGEXP.COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        keys1 = new HashMap<IElementType, TextAttributesKey>();
        keys2 = new HashMap<IElementType, TextAttributesKey>();
        RegExpHighlighter.fillMap(keys1, (TokenSet)RegExpTT.KEYWORDS, (TextAttributesKey)META);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, INVALID_CHARACTER_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, INVALID_CHARACTER_ESCAPE);
        keys1.put(TokenType.BAD_CHARACTER, BAD_CHARACTER);
        keys1.put(RegExpTT.BAD_HEX_VALUE, INVALID_CHARACTER_ESCAPE);
        keys1.put(RegExpTT.BAD_OCT_VALUE, INVALID_CHARACTER_ESCAPE);
        keys1.put(RegExpTT.PROPERTY, CHAR_CLASS);
        keys1.put(RegExpTT.ESC_CHARACTER, ESC_CHARACTER);
        keys1.put(RegExpTT.UNICODE_CHAR, ESC_CHARACTER);
        keys1.put(RegExpTT.HEX_CHAR, ESC_CHARACTER);
        keys1.put(RegExpTT.OCT_CHAR, ESC_CHARACTER);
        keys1.put(RegExpTT.CHAR_CLASS, ESC_CHARACTER);
        keys1.put(RegExpTT.BOUNDARY, ESC_CHARACTER);
        keys1.put(RegExpTT.CTRL, ESC_CHARACTER);
        keys1.put(RegExpTT.ESC_CTRL_CHARACTER, ESC_CHARACTER);
        keys1.put(RegExpTT.CATEGORY_SHORT_HAND, ESC_CHARACTER);
        keys1.put(RegExpTT.REDUNDANT_ESCAPE, REDUNDANT_ESCAPE);
        keys1.put(RegExpTT.QUOTE_BEGIN, QUOTE_CHARACTER);
        keys1.put(RegExpTT.QUOTE_END, QUOTE_CHARACTER);
        keys1.put(RegExpTT.NON_CAPT_GROUP, PARENTHS);
        keys1.put(RegExpTT.POS_LOOKBEHIND, PARENTHS);
        keys1.put(RegExpTT.NEG_LOOKBEHIND, PARENTHS);
        keys1.put(RegExpTT.POS_LOOKAHEAD, PARENTHS);
        keys1.put(RegExpTT.NEG_LOOKAHEAD, PARENTHS);
        keys1.put(RegExpTT.SET_OPTIONS, PARENTHS);
        keys1.put(RegExpTT.PYTHON_NAMED_GROUP, PARENTHS);
        keys1.put(RegExpTT.PYTHON_NAMED_GROUP_REF, PARENTHS);
        keys1.put(RegExpTT.RUBY_NAMED_GROUP, PARENTHS);
        keys1.put(RegExpTT.RUBY_QUOTED_NAMED_GROUP, PARENTHS);
        keys1.put(RegExpTT.GROUP_BEGIN, PARENTHS);
        keys1.put(RegExpTT.GROUP_END, PARENTHS);
        keys1.put(RegExpTT.LBRACE, BRACES);
        keys1.put(RegExpTT.RBRACE, BRACES);
        keys1.put(RegExpTT.CLASS_BEGIN, BRACKETS);
        keys1.put(RegExpTT.CLASS_END, BRACKETS);
        keys1.put(RegExpTT.COMMA, COMMA);
        keys1.put(RegExpTT.COMMENT, COMMENT);
    }
}

