/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.Reference;
import org.apache.sanselan.formats.ico.IcoImageParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IfsUtil {
    public static final String ICO_FORMAT = "ico";
    private static final Key<Long> TIMESTAMP_KEY = Key.create((String)"Image.timeStamp");
    private static final Key<String> FORMAT_KEY = Key.create((String)"Image.format");
    private static final Key<SoftReference<BufferedImage>> BUFFERED_IMAGE_REF_KEY = Key.create((String)"Image.bufferedImage");
    private static final IcoImageParser ICO_IMAGE_PARSER = new IcoImageParser();

    /*
     * Exception decompiling
     */
    private static boolean refresh(@NotNull VirtualFile file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static BufferedImage getImage(@NotNull VirtualFile file2) throws IOException {
        IfsUtil.refresh(file2);
        SoftReference imageRef = (SoftReference)file2.getUserData(BUFFERED_IMAGE_REF_KEY);
        return (BufferedImage)SoftReference.dereference((Reference)imageRef);
    }

    @Nullable
    public static String getFormat(@NotNull VirtualFile file2) throws IOException {
        IfsUtil.refresh(file2);
        return (String)file2.getUserData(FORMAT_KEY);
    }

    public static String getReferencePath(Project project2, VirtualFile file2) {
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project2).findLogicalRoot(file2);
        if (logicalRoot != null) {
            return IfsUtil.getRelativePath(file2, logicalRoot.getVirtualFile());
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file2);
        if (sourceRoot != null) {
            return IfsUtil.getRelativePath(file2, sourceRoot);
        }
        VirtualFile root = fileIndex.getContentRootForFile(file2);
        if (root != null) {
            return IfsUtil.getRelativePath(file2, root);
        }
        return file2.getPath();
    }

    private static String getRelativePath(VirtualFile file2, VirtualFile root) {
        if (root.equals(file2)) {
            return file2.getPath();
        }
        return "/" + VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)'/');
    }
}

