/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import java.awt.image.BufferedImage;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.jetbrains.annotations.NotNull;

public final class ImageEditorManagerImpl {
    private ImageEditorManagerImpl() {
    }

    @NotNull
    public static ImageEditorUI createImageEditorUI(BufferedImage image) {
        ImageEditorUI ui = new ImageEditorUI(null);
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        ui.getImageComponent().setGridVisible(gridOptions.isShowDefault());
        ui.getImageComponent().setTransparencyChessboardVisible(transparencyChessboardOptions.isShowDefault());
        ui.setImage(image, null);
        return ui;
    }
}

