/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.html;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import org.intellij.html.RelaxedHtmlFromRngElementDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelaxedHtmlFromRngNSDescriptor
extends RngNsDescriptor
implements RelaxedHtmlNSDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.html.RelaxedHtmlFromRngNSDescriptor");

    @Override
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        String namespace;
        XmlElementDescriptor elementDescriptor = super.getElementDescriptor(tag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor from rng for tag " + tag.getName() + " is " + (elementDescriptor != null ? elementDescriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (elementDescriptor == null && !(namespace = tag.getNamespace()).equals("http://www.w3.org/1999/xhtml")) {
            return new AnyXmlElementDescriptor(null, (XmlNSDescriptor)("http://www.w3.org/1999/html".equals(namespace) ? this : tag.getNSDescriptor(tag.getNamespace(), true)));
        }
        return elementDescriptor;
    }

    @Override
    protected XmlElementDescriptor initDescriptor(@NotNull XmlElementDescriptor descriptor) {
        return new RelaxedHtmlFromRngElementDescriptor(descriptor);
    }

    @Override
    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        Object[] descriptors = super.getRootElementsDescriptors(doc);
        Arrays.sort(descriptors);
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomTagDescriptors((PsiElement)doc));
    }
}

