/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import com.intellij.util.text.CharArrayCharSequence;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public final class ByteBufUtf8Writer
extends Writer {
    private final ByteBuf buffer;

    public ByteBufUtf8Writer(@NotNull ByteBuf buffer) {
        this.buffer = buffer;
    }

    public void write(@NotNull InputStream inputStream, int length) throws IOException {
        this.buffer.writeBytes(inputStream, length);
    }

    public void ensureWritable(int minWritableBytes) {
        this.buffer.ensureWritable(minWritableBytes);
    }

    @Override
    public void write(int c) {
        this.buffer.writerIndex(ByteBufUtilEx.writeChar(ByteBufUtilEx.getBuf(this.buffer), this.buffer.writerIndex(), c));
    }

    @Override
    public void write(char[] chars, int off, int len) {
        ByteBufUtilEx.writeUtf8(this.buffer, (CharSequence)new CharArrayCharSequence(chars, off, off + len));
    }

    @Override
    public void write(String str) {
        ByteBufUtilEx.writeUtf8(this.buffer, str);
    }

    @Override
    public void write(String str, int off, int len) {
        ByteBufUtilEx.writeUtf8(this.buffer, str, off, off + len);
    }

    @Override
    public Writer append(CharSequence csq) {
        if (csq == null) {
            ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)"null");
        } else {
            ByteBufUtilEx.writeUtf8(this.buffer, csq);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        ByteBufUtilEx.writeUtf8(this.buffer, csq, start, end);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

