/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWhileLoopWithDoWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new WhileLoopPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiStatement body = whileStatement.getBody();
        PsiExpression condition = whileStatement.getCondition();
        boolean infiniteLoop = BoolUtils.isTrue(condition);
        StringBuilder doWhileStatementText = new StringBuilder();
        if (!infiniteLoop) {
            doWhileStatementText.append("if(");
            if (condition != null) {
                doWhileStatementText.append(condition.getText());
            }
            doWhileStatementText.append(") {\n");
        }
        if (body instanceof PsiBlockStatement) {
            doWhileStatementText.append("do {");
            PsiBlockStatement blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children2 = codeBlock.getChildren();
            if (children2.length > 2) {
                for (int i = 1; i < children2.length - 1; ++i) {
                    PsiElement child = children2[i];
                    doWhileStatementText.append(child.getText());
                }
            }
            doWhileStatementText.append('}');
        } else if (body != null) {
            doWhileStatementText.append("do ").append(body.getText()).append('\n');
        }
        doWhileStatementText.append("while(");
        if (condition != null) {
            doWhileStatementText.append(condition.getText());
        }
        doWhileStatementText.append(");");
        if (!infiniteLoop) {
            doWhileStatementText.append("\n}");
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)whileStatement, doWhileStatementText.toString());
    }
}

