/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.varargs.VarargArgumentsPredicate;
import org.jetbrains.annotations.NotNull;

public class WrapVarargArgumentsWithExplicitArrayIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new VarargArgumentsPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (methodCallExpression == null) {
            return;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodExpressionText = methodExpression.getText();
        StringBuilder newExpression = new StringBuilder(methodExpressionText);
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        newExpression.append('(');
        int varargParameterIndex = parametersCount - 1;
        for (int i = 0; i < varargParameterIndex; ++i) {
            newExpression.append(arguments[i].getText());
            newExpression.append(", ");
        }
        PsiParameter[] parameters = parameterList.getParameters();
        PsiParameter varargParameter = parameters[varargParameterIndex];
        PsiArrayType type = (PsiArrayType)varargParameter.getType();
        newExpression.append("new ");
        PsiType componentType = type.getComponentType();
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType substitutedType = substitutor.substitute(componentType);
        newExpression.append(substitutedType.getCanonicalText());
        newExpression.append("[]{");
        if (arguments.length > varargParameterIndex) {
            newExpression.append(arguments[varargParameterIndex].getText());
            for (int i = parametersCount; i < arguments.length; ++i) {
                newExpression.append(", ");
                newExpression.append(arguments[i].getText());
            }
        }
        newExpression.append("})");
        PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
    }
}

