/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

class MakeMethodVarargsPredicate
implements PsiElementPredicate {
    MakeMethodVarargsPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (!(element instanceof PsiParameterList)) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        PsiParameterList parameterList = (PsiParameterList)element;
        if (!(element.getParent() instanceof PsiMethod)) {
            return false;
        }
        if (parameterList.getParametersCount() == 0) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        PsiParameter lastParameter = parameters[parameters.length - 1];
        if (lastParameter.isVarArgs()) {
            return false;
        }
        PsiType type = lastParameter.getType();
        return type instanceof PsiArrayType;
    }
}

