/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandOneLineLambda2CodeBlockIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExpandOneLineLambda2CodeBlockIntention.class.getName()));

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new LambdaExpressionPredicate();
    }

    @Override
    @NotNull
    public String getText() {
        return "Expand lambda expression body to {...}";
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        RefactoringUtil.expandExpressionLambdaToCodeBlock(element);
    }

    private static class LambdaExpressionPredicate
    implements PsiElementPredicate {
        private LambdaExpressionPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            return lambdaExpression != null && lambdaExpression.getBody() instanceof PsiExpression;
        }
    }
}

