/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplaceableWithOperatorAssignmentPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithOperatorAssignmentIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiExpression rhs = assignmentExpression.getRExpression();
        PsiPolyadicExpression expression = (PsiPolyadicExpression)PsiUtil.deparenthesizeExpression((PsiExpression)rhs);
        assert (expression != null);
        PsiJavaToken sign = expression.getTokenBeforeOperand(expression.getOperands()[1]);
        assert (sign != null);
        String operator = sign.getText();
        return IntentionPowerPackBundle.message("replace.assignment.with.operator.assignment.intention.name", operator);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ReplaceableWithOperatorAssignmentPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
        PsiExpression rhs = expression.getRExpression();
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)PsiUtil.deparenthesizeExpression((PsiExpression)rhs);
        assert (polyadicExpression != null);
        PsiExpression lhs = expression.getLExpression();
        assert (rhs != null);
        PsiExpression[] operands = polyadicExpression.getOperands();
        PsiJavaToken sign = polyadicExpression.getTokenBeforeOperand(operands[1]);
        assert (sign != null);
        String signText = sign.getText();
        StringBuilder newExpression = new StringBuilder();
        newExpression.append(lhs.getText()).append(signText).append('=');
        boolean token = false;
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            if (token) {
                newExpression.append(signText);
            } else {
                token = true;
            }
            newExpression.append(operand.getText());
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression.toString());
    }
}

