/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplaceOperatorAssignmentWithPostfixExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceOperatorAssignmentWithPostfixExpressionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
        PsiExpression expression = assignment.getLExpression();
        PsiJavaToken sign = assignment.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        String replacementText = JavaTokenType.PLUSEQ.equals(tokenType) ? expression.getText() + "++" : expression.getText() + "--";
        return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", sign.getText(), replacementText);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ReplaceOperatorAssignmentWithPostfixExpressionPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String newExpressionText;
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
        PsiExpression expression = assignment.getLExpression();
        String expressionText = expression.getText();
        IElementType tokenType = assignment.getOperationTokenType();
        if (JavaTokenType.PLUSEQ.equals(tokenType)) {
            newExpressionText = expressionText + "++";
        } else if (JavaTokenType.MINUSEQ.equals(tokenType)) {
            newExpressionText = expressionText + "--";
        } else {
            return;
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignment, newExpressionText);
    }
}

